package fr.cnam.horloge.vue;

import java.util.*;
import fr.cnam.horloge.model.ModelHorloge;
import fr.cnam.horloge.model.HeureHorloge;
import fr.cnam.horloge.controleur.*;

import fr.cnam.ihm.*;

// Classe de dfinition de la vue qui saisie une nouvelle heure pour 
//  l'horloge
//
public class VueSaisirHeureHorloge implements FormulaireInt
{
  private Formulaire  form;   // L'ihm de la vue
  private ControleurHorloge     controleur;  // Le controleur
  
  //Constructeur
  public VueSaisirHeureHorloge()
  {
      // Recuperation du controleur
    controleur = ControleurHorlogeImpl.getInstance();
    
    // Creation du formulaire
    form = new Formulaire("HORLOGE",this,300,200);
    form.setTailleFonte(20);
    form.setHeightText(30);
    form.addText("HEURE","Heure",true,"");
    form.addText("MINUTE","Minute",true,"");
    form.addText("SECONDE","Seconde",true,"");
    form.addButton("VALIDER","Valider");
    form.addText("ERREUR","",false,"");
  }
  
  // Affiche la vue permettant de saisir l'heure de l'horloge
  //
  public void afficher()
  {
    form.afficher(10,200);
  }
  
  // Action dans l'ihm
  public void submit(Formulaire form,String nom)
  {
    form.setValeurChamp("ERREUR","");
    HeureHorloge heureHorloge = null;
    try{
      int h = Integer.parseInt(form.getValeurChamp("HEURE"));
      int m = Integer.parseInt(form.getValeurChamp("MINUTE"));
      int s = Integer.parseInt(form.getValeurChamp("SECONDE"));
      heureHorloge = new HeureHorloge(h,m,s);
    }catch(Exception ex)
      {
        form.setValeurChamp("ERREUR","Erreur");
      }
    
    controleur.actionChangerHeureHorloge(heureHorloge);
  }
}

