package fr.cnam.horloge.vue;

import java.util.*;
import fr.cnam.horloge.model.ModelHorloge;
import fr.cnam.horloge.model.HeureHorloge;
import fr.cnam.horloge.controleur.*;

import fr.cnam.ihm.*;

// Classe de dfinition de la vue qui permet de saisir
//  le nom de l'horloge
//
public class VueSaisirNomHorloge implements FormulaireInt
{
    private Formulaire             form;   // L'ihm de la vue
    
    //Constructeur
    public VueSaisirNomHorloge()
    {
        // Creation du formulaire
      form = new Formulaire("HORLOGE",this,300,200);
    form.setTailleFonte(20);
    form.setHeightText(30);
    form.addText("NOM","Nom",true,"");
    form.addButton("VALIDER","Valider");
    form.addButton("START","Start");
    form.addButton("STOP","Stop");
    }

    // Affiche de la vue permettant de saisir le nom de l'horloge
    //
    public void afficher()
    {
        form.afficher(10,500);
    }

    // Action dans l'ihm
    public void submit(Formulaire form,String nom)
    {
        if (nom.equals("VALIDER"))
            {
                String  nomHorloge = form.getValeurChamp("NOM");
                
                ControleurHorloge controleur = ControleurHorlogeImpl.getInstance();
                controleur.actionRenommerHorloge(nomHorloge);
            }
        if (nom.equals("START"))
            {
                ControleurHorloge controleur = ControleurHorlogeImpl.getInstance();
                controleur.actionStartHorloge();
            }

        if (nom.equals("STOP"))
            {
                ControleurHorloge controleur = ControleurHorlogeImpl.getInstance();
                controleur.actionStopHorloge();
            }
    }

}

