// Exemple simple du DP Visitor.
// Exporter des formes en XML.
//

import java.util.*;

// Programme principal
//  
public class ExempleCh04_12
{
  public static void main(String... args) {

    // Une liste de forme graphique generique
    //    Point, Cercle, Rectangle, Comps de forme
    //
    ArrayList<Shape> shapes = new ArrayList<Shape>();
    shapes.add(new Dot());
    shapes.add(new Circle());
    shapes.add(new Rectangle());
    shapes.add(new CompoundShape());

    // Cration du visiteur
    //
    XMLExportVisitor exportVisitor = new XMLExportVisitor();
    
    // Sur toutes les formes de la liste, on fait appel
    //  au visiteur
    //
    for(Shape shape : shapes){
      shape.accept(exportVisitor);
    }

    // Exemple d'un deuxime visiteur 
    Visiter2 v = new Visiter2();

    for(Shape shape : shapes){
      shape.accept(v);
    }
  }
}

// La classe abstraite de la forme dont toutes les formes hritent.
// On ajoute dans cette classe abstraite la mthode qui permet d'accepter l'excution
//  d'un visiteur
//
abstract class Shape  {
  // ....
  //Les mthodes communes  toutes les formes (move, draw, ...)
  // ....

  // La mthode qui accepte l'excution d'un visiteur pour 
  //  une instance de Shape
  //
  abstract public void accept(Visitor v);  // Ncessaire car appel gnrique
  public void accept(Visitor2 v){  // Ncessaire car appel gnrique
    // Pour les classes qui n'ont pas le visiteur 2
  }
}

// On ajoute dans chaque classe qui accepte l'excution d'un visiteur, la
// mthode qui va faire l'appel au visiteur
// --------------------------------------------------------------------
class Dot extends Shape {
    // ...
  public void accept(Visitor v) {
    v.visitDot(this);
  }
  public void accept(Visitor2 v) { // Pour l'exemple d'un 2me visiteur
    v.visitDot(this);
  }
}

class Circle extends Shape {
    // ...
  public void accept(Visitor v) {
    v.visitCircle(this);
  }
}

class Rectangle extends Shape {
    // ...
  public void accept(Visitor v) {
    v.visitRectangle(this,bidon(100));
  }

  private int bidon(int x){return x*10;}
}

class CompoundShape extends Shape {
    // ...
  public void accept(Visitor v) {
    v.visitCompoundShape(this);
  }
}

// -----------------------------------------------------------

// L'interface de dfinition du Visiteur.
// Cela revient  "lister" toutes les classes qui acceptent un visiteur.
//
//
interface Visitor {
  public void visitDot(Dot d);
  public void visitCircle(Circle c);
  public void visitRectangle(Rectangle r,int param);
  public void visitCompoundShape(CompoundShape cs);
}

// Classe d'implmentation du comportement d'un visiteur.
// Ici on prend l'exemple d'exporter en XML les objets.
//
class XMLExportVisitor implements Visitor {
  public void visitDot(Dot d) {
    System.out.println("Export the dot's ID and center coordinates");
  }

  public void  visitCircle(Circle c) {
    System.out.println("Export the circle's ID, center coordinates and radius");
  }

  public void visitRectangle(Rectangle r,int x) {
    System.out.println("Export the rectangle's ID, left-top coordinates,width and height");
    System.out.println("Paramtre : "+x);
  }

  public void visitCompoundShape(CompoundShape cs) {
    System.out.println("Export the shape's ID as well as the list of its children's IDs");
  }
}


// Exemple de la dfinition d'un deuxime visiteur
//
interface Visitor2 {
  public void visitDot(Dot d);
}

class Visiter2 implements Visitor2 {
  public void visitDot(Dot d){
    System.out.println("Je viste un point");
  }
}
