/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class Terminal {
    private static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    public static String[] lireFichierTexte(String string) {
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            String string2 = new String(byArray);
            String string3 = string2.replaceAll("\r", "");
            String[] stringArray = string3.split("\n");
            return stringArray;
        }
        catch (Exception exception) {
            Terminal.exceptionHandler(exception);
            return null;
        }
    }

    public static void ecrireFichier(String string, StringBuffer stringBuffer) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            byte[] byArray = stringBuffer.toString().getBytes();
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Terminal.exceptionHandler(exception);
        }
    }

    public static String lireString() {
        String string = "";
        boolean bl = false;
        try {
            string = in.readLine();
        }
        catch (IOException iOException) {
            Terminal.exceptionHandler(iOException);
        }
        return string;
    }

    public static int lireInt() {
        int n = 0;
        try {
            n = Integer.parseInt(Terminal.lireString());
        }
        catch (NumberFormatException numberFormatException) {
            Terminal.exceptionHandler(numberFormatException);
        }
        return n;
    }

    public static boolean lireBoolean() {
        boolean bl = true;
        try {
            bl = Boolean.valueOf(Terminal.lireString());
        }
        catch (NumberFormatException numberFormatException) {
            Terminal.exceptionHandler(numberFormatException);
        }
        return bl;
    }

    public static double lireDouble() {
        double d = 0.0;
        try {
            d = Double.valueOf(Terminal.lireString());
        }
        catch (NumberFormatException numberFormatException) {
            Terminal.exceptionHandler(numberFormatException);
        }
        return d;
    }

    public static char lireChar() {
        String string = Terminal.lireString();
        if (string.length() == 0) {
            return '\n';
        }
        return string.charAt(0);
    }

    public static void ecrireString(String string) {
        System.out.print(string);
    }

    public static void ecrireStringln(String string) {
        Terminal.ecrireString(string);
        Terminal.sautDeLigne();
    }

    public static void ecrireInt(int n) {
        Terminal.ecrireString("" + n);
    }

    public static void ecrireIntln(int n) {
        Terminal.ecrireString("" + n);
        Terminal.sautDeLigne();
    }

    public static void ecrireBoolean(boolean bl) {
        Terminal.ecrireString("" + bl);
    }

    public static void ecrireBooleanln(boolean bl) {
        Terminal.ecrireString("" + bl);
        Terminal.sautDeLigne();
    }

    public static void ecrireDouble(double d) {
        Terminal.ecrireString("" + d);
    }

    public static void ecrireDoubleln(double d) {
        Terminal.ecrireDouble(d);
        Terminal.sautDeLigne();
    }

    public static void ecrireChar(char c) {
        Terminal.ecrireString("" + c);
    }

    public static void ecrireCharln(char c) {
        Terminal.ecrireChar(c);
        Terminal.sautDeLigne();
    }

    public static void sautDeLigne() {
        try {
            System.out.println();
        }
        catch (Exception exception) {
            Terminal.exceptionHandler(exception);
        }
    }

    protected static void exceptionHandler(Exception exception) {
        TerminalException terminalException = new TerminalException(exception);
        throw terminalException;
    }

    public static void ecrireException(Throwable throwable) {
        Terminal.ecrireString(throwable.toString());
        throwable.printStackTrace(System.out);
    }
}

