// Server.java
// Le serveur stocke les objets créés dansune table de hashing.
// La clef de hashage des objets sont utilisés comme clef de recherche.
//
// Le serveur gère l'appel de toutes les méthodes distantes.
//
import java.util.*;
import java.io.*;
import java.net.*;

// ===================================
public class Server2
{
    static private Service service;
    static private Hashtable<Integer,Media> tableOD;

    public static void main(String args[]) throws Exception
        {
            int port = Integer.parseInt(args[0]);
            service = new Service();
            tableOD = new Hashtable<Integer,Media>();

            ServerSocket ssoc = new ServerSocket(port);
            while (true)
                {
                    Socket soc = ssoc.accept();
                    OutputStream os=soc.getOutputStream();
                    ObjectOutputStream oos=new ObjectOutputStream(os);
                    InputStream is=soc.getInputStream();
                    ObjectInputStream ois=new ObjectInputStream(is);
                    
                    String methode = (String)(ois.readObject());

                    if (methode.equals("creerLivre"))
                        {
                            System.out.println("Creation d'un livre");
                            String nom = (String)(ois.readObject());
                            Livre l = (Livre)(service.creerLivre(nom));
                            tableOD.put(new Integer(l.hashCode()),l);

                            // on retourne un stub 
                            LivreStub lstub = new LivreStub(l,
                                                            InetAddress.getLocalHost().getHostName(),
                                                            port
                                                            );
                            oos.writeObject(lstub);
                        }

                    if (methode.equals("creerDVD"))
                        {
                            System.out.println("Creation d'un DVD");
                            String nom = (String)(ois.readObject());
                            DVD d = (DVD)(service.creerDVD(nom));
                            tableOD.put(new Integer(d.hashCode()),d);

                            // on retourne un stub 
                            DVDStub dstub = new DVDStub(d,
                                                        InetAddress.getLocalHost().getHostName(),
                                                        port);
                            oos.writeObject(dstub);
                        }

                    if (methode.equals("getNom"))
                        {
                            System.out.print("getNom");
                            Integer hashCode = (Integer)(ois.readObject());
                            Media m = tableOD.get(hashCode);
                            System.out.println(" de "+m.hashCode());
                            oos.writeObject(m.getNom());
                        }

                    if (methode.equals("getType"))
                        {
                            System.out.print("getType");
                            Integer hashCode = (Integer)(ois.readObject());
                            Media m = tableOD.get(hashCode);
                            System.out.println(" de "+m.hashCode());
                            oos.writeObject(m.getType());
                        }
                    soc.close();
                }
        }
}