import java.util.*;
import java.io.*;
import java.net.*;

public class MyRMIServerSocket implements Runnable
{
    private ArrayList<MyRemoteObjectInvocation> skeltons;
    private ServerSocket ssoc;
    private static MyRMIServerSocket myssoc = null;

    static public MyRMIServerSocket getInstance(int port)
    {
        if (myssoc==null)
            {
                myssoc = new MyRMIServerSocket(port);
                return myssoc;
            }
        else
            return myssoc;
    }

    private  MyRMIServerSocket(int port)
    {
        try{
            skeltons = new ArrayList<MyRemoteObjectInvocation>();
            ssoc     = new ServerSocket(port);
            Thread t = new Thread(this);
            t.start();
        }catch(Exception ex)
            {
                System.out.println("Erreur dans MyRMIServerSocket");
                System.out.println(ex);
                ex.printStackTrace();
            }
    }

    synchronized public void addRemoteObject(MyRemoteObjectInvocation sk)
    {
        System.out.println("Ajout d'un skelton: "+sk.getHashCode());
        skeltons.add(sk);
    }

    public void run()
    {
        try{
            while (true)
                {
                    Socket soc = ssoc.accept();
                    OutputStream os=soc.getOutputStream();
                    ObjectOutputStream oos=new ObjectOutputStream(os);
                    InputStream is=soc.getInputStream();
                    ObjectInputStream ois=new ObjectInputStream(is);

                    Integer hashCodeRemote = (Integer)(ois.readObject());
                    String methode = (String)(ois.readObject());

                    MyRemoteObjectInvocation skelton = null;
                    for(MyRemoteObjectInvocation sk : skeltons)
                        if (sk.getHashCode() == hashCodeRemote.intValue())
                            skelton = sk;
                    
                    if(skelton!=null)
                        {
                            System.out.println(">>invoke de "+methode);
                            skelton.invoke(methode,oos,ois);
                        }
                    else
                        {
                            System.out.println("ERREUR: skelton non trouve: "+hashCodeRemote.intValue());
                        }
                }
        }catch(Exception ex)
            {
                System.out.println("Erreur dans MyRMIServerSocket : run");
                System.out.println(ex);
                ex.printStackTrace();
            }
    }
}