import java.net.*;

public abstract class MyUnicastRemoteObject extends MyRemoteObject implements MyRemote
{
    private MyRMIServerSocket         ssoc;
    private MyRemoteObjectInvocation  skelton;

    public MyUnicastRemoteObject(int port)
    {
        super(port);
        ssoc = MyRMIServerSocket.getInstance(port); // Singleton

        // Creation du skelton
        try{
            Class c = Class.forName(getClass().getName()+"Skelton",true,this.getClass().getClassLoader());
            skelton = (MyRemoteObjectInvocation)(c.getConstructor(this.getClass()).newInstance(this));
        }catch(Exception ex){ex.printStackTrace();};
    }

    public MyRemoteObjectInvocation getSkelton()
    {
        return skelton;
    }

    public MyRemoteObject exportObject()
    {
        ssoc.addRemoteObject(skelton);
        return skelton;
    }

  abstract public MyRemote toStub();
}