import java.io.*;
import java.net.*;

//  La communication se fait par socket et serialisation des donnees
//
public class ServiceInvoker implements ServiceInt, Serializable
{
    private String host;
    private int    port;
    private int    hashCode;

    public ServiceInvoker(int hashCode,String host,int port)
    {
        this.host = host;
        this.port = port;
        this.hashCode = hashCode;
    }

    public MediaInt creerLivre(String nom)
    {
        try{
            Socket soc;
            if (host.equals("localhost"))
                soc = new Socket(InetAddress.getLocalHost(),port);
            else soc = new Socket(host,port);
            OutputStream os=soc.getOutputStream();
            ObjectOutputStream oos=new ObjectOutputStream(os);
            InputStream is=soc.getInputStream();
            ObjectInputStream ois=new ObjectInputStream(is);
            
            oos.writeObject(new Integer(hashCode));
            oos.writeObject("creerLivre");
            oos.writeObject(nom);
            MediaInt m = (MediaInt)(ois.readObject());
            soc.close();
            return m;
        }
        catch(Exception ex){System.out.println("ERREUR InvokerService :"+ex);return null;}
    }

    public MediaInt creerDVD(String nom)
    {
        try{
            Socket soc;
            if (host.equals("localhost"))
                soc = new Socket(InetAddress.getLocalHost(),port);
            else soc = new Socket(host,port);
            OutputStream os=soc.getOutputStream();
            ObjectOutputStream oos=new ObjectOutputStream(os);
            InputStream is=soc.getInputStream();
            ObjectInputStream ois=new ObjectInputStream(is);
                        
            oos.writeObject(new Integer(hashCode));
            oos.writeObject("creerDVD");
            oos.writeObject(nom);
            MediaInt m = (MediaInt)(ois.readObject());
            soc.close();
            return m;
        }catch(Exception ex){System.out.println("ERREUR InvokerService :"+ex);return null;}
    }
}