import java.io.*;

public class ServiceOD extends MyUnicastRemoteObject implements ServiceODInt
{
    private ServiceInt service;
    private int port;

    public ServiceOD(int port)
    {
        super(port);
        service = new Service();
        this.port = port;
    }

    public MediaInt creerLivre(String nom) throws MyRemoteException
    {
        System.out.println("ServiceOD : Creer livre");

        MediaInt m = service.creerLivre(nom);
        LivreOD lod = new LivreOD(port,(Livre)m);
        lod.exportObject();
        MyRemote stub = lod.toStub();
        return (MediaInt)stub;
    }

    public MediaInt creerDVD(String nom) throws MyRemoteException
    {
        System.out.println("ServiceOD : Creer DVD");
       
        MediaInt m = service.creerDVD(nom);
        DVDOD dod = new DVDOD(port,(DVD)m);
        dod.exportObject();
        MyRemote stub = dod.toStub();
        return (MediaInt)stub;
    }

    public MyRemote toStub()
    {
        return new ServiceStub(getHashCode(),
                               getHost(),
                               getPort());
    }
}

