import java.util.*;
import java.io.*;
import java.net.*;

public class ServiceODSkelton extends MyRemoteObjectInvocation
{
    private ServiceOD serviceOD;

    public ServiceODSkelton(ServiceOD serviceOD)
    {
        super(serviceOD.getPort(),serviceOD);
        this.serviceOD = serviceOD;
    }

    public void invoke(String methode,
                       ObjectOutputStream oos,
                       ObjectInputStream ois) throws MyRemoteException
    {
        try{
            if (methode.equals("creerLivre"))
                {
                    System.out.println("Creation d'un livre");
                    String nom = (String)(ois.readObject());
                    MediaInt m = serviceOD.creerLivre(nom);
                    oos.writeObject(m);
                }
            
            if (methode.equals("creerDVD"))
                {
                    System.out.println("Creation d'un DVD");
                    String nom = (String)(ois.readObject());
                    MediaInt m = serviceOD.creerDVD(nom);
                    oos.writeObject(m);
                }
        }catch(Exception ex)
            {
                System.out.println("Erreur dans SkeltonService : invoke");
                System.out.println(ex);
                ex.printStackTrace();
                throw new MyRemoteException(ex);
            }
    }
}