//IhmXXXClient.java
//
//
import java.lang.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.rmi.*;

import cnamp.ihm.*;
import cnamp.app.*;

public class Client
{
  public static void main(String args[]) throws Exception
  {
    String  hostname = "";  // hostname du serveur
    int     port     = 0;   // port de l'adpaptateur
    String nomRegisterXXX = "";
    try{
      hostname  = args[0];
      port      = Integer.parseInt(args[1]);
      nomRegisterXXX = args[2];
    }catch(Exception e)
      {
        System.out.println("Mauvais parametrage: host port nomRegister");
        return;
      }

    AppXXXInt app = new IhmXXXRmiImp(hostname,port,nomRegisterXXX);
    IhmXXX ihm = new IhmXXX(app);

    // Affichage de l'IHM
    afficherDansFrame(ihm);
        
    // Initialisation de l'IHM
    ihm.initialiser();
  }

  // Affiche l'ihm dans un frame
  //
  private static void afficherDansFrame(IhmXXX ihm)
  {
    final JFrame _frame = new JFrame();
    final IhmXXX _ihm = ihm;

    _frame.addWindowListener(new WindowAdapter()
      {
        public void windowClosing(WindowEvent e)
        {
          _ihm.terminer();
          _frame.dispose();
        }
      });
    _frame.getContentPane().add(_ihm.getPanel());
    _frame.setSize(_ihm.getWidth(),_ihm.getHeight());
    _frame.show();
  }

}
