//IhmXXX.java
//
//
package cnamp.ihm;

import java.lang.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import cnamp.app.AppXXXInt;

public class IhmXXX implements Runnable
{
  private AppXXXInt _app;            // L'applicatif du jeu
  private Thread _thread;            // Thread de l'ihm
  private boolean _finThread;        // fin du thread

  private JPanel              _panel;        // Panel general de l'IHM
  private JTextField          _texte; 
  private JTextField          _texte2;
  private JButton             _action;
		
  // ======================================================================
  // Constructeur de l'IHM
  //
  public IhmXXX(AppXXXInt app)
  {
    // Initialisation des attributs non graphiques
    //
    _app          = app;
    _thread       = new Thread(this);
    _finThread    = false;
				
    // Creation des composants graphiques
    //
    _panel       = new JPanel(new GridLayout(2,1));
    _texte       = new JTextField("");
    _texte2      = new JTextField("");
    _action      = new JButton("Faire");
    Font f = new Font("courrier",Font.BOLD,18);
    _texte.setFont(f);
    _texte2.setFont(f);
    _action.setFont(f);


    // Ajout des composants dans les panels
    //
    _panel.add(_texte);
    _panel.add(_texte2);
    _panel.add(_action);

				
    // Creation des listeners
    //
    class FaireAction implements ActionListener
    {
      public void actionPerformed(ActionEvent evt)
      {
        _app.setPrefixe(_texte2.getText());
      }
    }

    // Ajout des listeners
    //
    _action.addActionListener( new FaireAction());
				
  }

  // ======================================================================
  // Initialisation de l'IHM
  //    
  public void initialiser()
  {
    _thread.start();
  }

  // ======================================================================
  // Terminaison de l'IHM
  //
  public void terminer()
  {
    _finThread = true;
  }

  // ======================================================================
  // Retourne le panel principal de l'IHM
  // 
  public JPanel getPanel()
  {
    return(_panel);
  }

  // ======================================================================
  // Accesseurs de la taille de la grille
  //
  public int getWidth(){return(800);}
  public int getHeight(){return(200);}


  // ======================================================================
  // Traitement du thread
  //
  public void run()
  {
    while (! _finThread)
      {
        try{
          Thread.sleep(500);
          String valeur = _app.getDate();
          if (valeur != null)
            _texte.setText(valeur);
          else
            _texte.setText("NULL");
        }
        catch(Exception e){};
      }
  }
}
