// LoadClassServlet.java
//
package cnamp.myhttp;

// Classe permet de charger dynamiquement une classe de servlet
//  dans un repertoire dfini par le constructeur
//  
import java.awt.*;
import java.io.*;
import java.lang.*;
import java.net.*;

public class LoadClassServlet extends ClassLoader
{
  String _repertoire;   // Le repertoire dans lequel on cherche la classe

  // Constructeur
  //
  public LoadClassServlet(String repertoireWWW)
  {
    _repertoire = repertoireWWW;
  }
  
  // Mthode qui retourne une classe Java  partir
  //  du nom de sa classe : interprtation du fichier .class
  // Retourne null si erreur
  //
  public Class findClass(String nomServlet) throws ClassNotFoundException
  {
    File fic;
    FileInputStream fis;
    Class c=null;

    //Lecture du fichier dans un tableau de byte
    try 
      {
        // Le fichier de la classe
        fic = new File(new File(_repertoire,"servlets"),
                       nomServlet+".class");
        fis = new FileInputStream(fic);

        // Lecture du fichier dans un buffer
        //
        byte[] donnees = new byte[(int) fic.length()];
        int octetslus=fis.read(donnees);
        fis.close();
		
        // Cration de la classe en fonction de
        //  sa valeur en binaire:  reconnaissance
        //  de la classe par la machine virtuelle
        //

        c = (Class)(defineClass(nomServlet,donnees,0,donnees.length));
        resolveClass(c);
      }
    catch (Exception e)
      {
        // Si erreur alors la classe retourne est null
      }

    return(c);
  }
}

