// MyHttpServlet.java
//
// Classe utilise par les servlets pour s'executer.
// Elle est cree par le serveur Http afin de le servlet y 
// trouve tous ceux dont il a besoin :
//     - le nom de servlet
//     - Les flots d'ecriture et de lecture du socket
//     - Les mots clef d'une requete
//

package cnamp.myhttp;

import java.lang.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class MyHttpServlet
{
  private Hashtable      _motsclef;    // Les mmots clef de la requete Http
  private String         _nomServlet;  // Le nom du servlet
  private PrintStream    _output;      // Le flot d'ecriture du socket
  private BufferedReader _input;       // Le flot de lecture du socket
   
  // Constructeur
  //    - init des attributs
  //    - decodage des mots clef de la requete
  //
  public MyHttpServlet(
                       BufferedReader input,
                       PrintStream    output,
                       String         requete
                       )

  {
    StringTokenizer strtok;

    _motsclef          = new Hashtable();  // Les mots clefs sont stockes
    //   dans un Hashtable
    _output            = output;           // Flot d'ecriture
    _input             = input;            // Flot de lecture
      
    // La requete recue peut etre une des formes suivantes :
    //     nom_servlet
    //     nom_servlet?mots_clefs
    //  avec
    //    mots_clefs de la forme :  mot1=valeur2&mot2=valeur2&...
    //
    strtok = new StringTokenizer(requete,"?");

    if (strtok.hasMoreTokens())
      {
        _nomServlet = strtok.nextToken();
        if (strtok.hasMoreTokens())
          {
	    // Decodage des mots cefs
	    decoderMotsClefs(strtok.nextToken());
          }
      }
    else
      {
        _nomServlet = requete;
      }
  }

  // Retourne le nom du servlet
  public String getNomServlet(){return(_nomServlet);}

  // Retourne le flot d'ecriture
  public PrintStream getOutputStream(){return(_output);}

  // Retourne le flot de lecture
  public BufferedReader getInputStream(){return(_input);}

  // Decodage des mots clef de la requete
  private void decoderMotsClefs(String formulaire)
  {
    StringTokenizer strtok = new StringTokenizer(formulaire,"&");
    while(strtok.hasMoreTokens())
      {
        StringTokenizer element = new StringTokenizer(strtok.nextToken(),"=");
        String champ="";
        String valeur="";
        if(element.hasMoreTokens()) champ = element.nextToken();
        if(element.hasMoreTokens()) valeur = element.nextToken();
        _motsclef.put(champ,valeur);
      }
  }

  // Ajoute un mot clef dans le Hashtable
  private void addMotClef(String champ,Object objet)
  {
    _motsclef.put(champ,objet);
  }

  // Retourne le nombre de mots clefs    
  public int getNbChamps()
  {
    return(_motsclef.size());
  }

  // Retourne le n-ieme mot clef
  public String getChamp(int n)
  {
    int i = 0;
    for (Enumeration e = _motsclef.keys() ; e.hasMoreElements() ;) 
      {
        if (i==n) return ( (String)e.nextElement());
        i++;
        e.nextElement();
      }
    return(null);
  }
    
  // Retourne la valeur d'un mot clef
  public String getValeur(String champ)
  {
    return((String)(_motsclef.get(champ)));
  }

  // Cette methode est appele dans Httpd dans le cas d'une requete POST
  // Elle consiste a lire le socket qui contient le reste de la requete
  // Ce reste contient une entete terminer par une ligne vide.
  // L'entete contient le nombre d'octet de l'information des mots clefs.
  //
  public void initPost()
  {
    try
      {
        // Lecture de l'entete et determination de la longueur du
        // reste de l'information qui suit l'entete
        //
        boolean ok=true;
        String line= _input.readLine();
        int nb=0;
        while(line!=null)
          {
            line = _input.readLine();
            if (line!=null)
              {
                System.out.println("==================== "+line);
                String content="Content-Disposition: form-data; name=\"";
                if (line.indexOf(content)!=-1)
                  {
                    String champ=line.substring(content.length(),line.indexOf("\"",content.length()));
                    String sl = _input.readLine();
                    if (sl!=null)
                      {
                        String valeur = _input.readLine();
                        if (valeur!=null)
                          {
                            valeur = valeur.replace("\n","").replace("\r","");
                            System.out.println(">>>" + champ + "," + valeur);
                            addMotClef(champ,valeur);
                          }
                      }
                  }
              }
          }
      }
    catch(Exception e)
      {
        System.out.println("Erreur dans initPost: "+e.toString());
      }
  }
}
