package cnamp.myhttp;

import java.io.*;
import java.net.InetSocketAddress;
import java.util.*;
import java.util.concurrent.Executors;
 
import com.sun.net.httpserver.*;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;

import cnamp.myhttp.*;
 
public class ServeurHttp {
  public static void main(String[] args) throws IOException {
    InetSocketAddress addr = new InetSocketAddress(Integer.parseInt(args[0]));
    String www = args[1];
    HttpServer server = HttpServer.create(addr, 0);
 
    server.createContext("/", new Gestionnaire(www));
    // server.setExecutor(Executors.newCachedThreadPool());
    server.start();
    System.out.println("Le serveur en ecoute sur le port: "+addr.getPort());
  }
}
 
class Gestionnaire implements HttpHandler {
  
  private String www;
  private OutputStream outputRequest;
  private InputStream inputRequest;
  private String methodeRequete;

  public Gestionnaire(String www)
  {
    this.www=www;
  }
 
  public void handle(HttpExchange exchange) throws IOException {
    methodeRequete = exchange.getRequestMethod();
    System.out.println("\n------------------------------");
    System.out.println("methode : "+methodeRequete);
    String path  = exchange.getRequestURI().getPath();
    String query = exchange.getRequestURI().getQuery();
    if (query!=null) path = path+"?"+query;
    System.out.println(path);
    System.out.println("------------------------------");

    inputRequest  = exchange.getRequestBody();
    outputRequest = exchange.getResponseBody();

      /*
      Headers requeteEntete = exchange.getRequestHeaders();
      Set<String> keySet = requeteEntete.keySet();
      Iterator<String> iter = keySet.iterator();
      while (iter.hasNext()) {
        String key = iter.next();
        List values = requeteEntete.get(key);
        String s = key + " = " + values.toString() + "";
        //System.out.println(s);
        outputRequest.write(s.getBytes());
      }
      */

      if (path.equals("/"))  path = "/index.html";

      String mcserv = "/servlet/";
      int pos = path.indexOf(mcserv);
      if (pos==0) traiterServlet(exchange,path.substring(pos+mcserv.length()));
      else repondreFichier(exchange,path);

      outputRequest.close();

  }//handle

  public void repondreFichier(HttpExchange exchange,String path) throws IOException
  {
    File fic;
    FileInputStream fis;
    fic = new File(www,path);
    if (fic.exists())
      {
        String name = fic.getName();
        int dot = name.lastIndexOf('.');
        String base = (dot == -1) ? name : name.substring(0, dot);
        String extension = (dot == -1) ? "" : name.substring(dot+1);

        String[] tab = name.split("[.]");
        if ( (tab!=null) && (tab.length==2) )
          {
            System.out.println("extension : "+tab[1]);
            extension = tab[1];
          }
        Headers reponseEntete = exchange.getResponseHeaders();
        if (extension.equals("html"))
          reponseEntete.set("Content-Type", "text/html");
        else if (extension.equals("js"))
          reponseEntete.set("Content-Type", "text/javascript");
        else
          reponseEntete.set("Content-Type", "text/pain");

        exchange.sendResponseHeaders(200, 0);
 
        String crfl="\r\n";
        outputRequest.write(crfl.getBytes());

        System.out.println("repondreFichier: "+path);
        fis = new FileInputStream(fic);
        byte[] donnees = new byte[(int) fic.length()];
        fis.read(donnees);
        fis.close();
        outputRequest.write(donnees);
      }
    else
      {
        String mess="Le fichier n'existe pas : "+path;
        System.out.println(mess);
      }
  }

  public void repondreChaine(HttpExchange exchange,String chaine) throws IOException
  {
    Headers reponseEntete = exchange.getResponseHeaders();
    reponseEntete.set("Content-Type", "text/html");
    exchange.sendResponseHeaders(200, 0);
    String crfl="\r\n";
    outputRequest.write(crfl.getBytes());
    chaine="<h1>"+chaine+"<h2>";
    outputRequest.write(chaine.getBytes());
  }


  // Traitement d'un servlet
  //    il s'agit de decoder la requete afin de :
  //     determiner le servlet demande
  //     decoder les mots clefs de la requete (dans le cas GET et POST)
  //     d'executer dynamiquement le servlet
  //
  public void traiterServlet(HttpExchange exchange,String servletHttp) throws IOException
  {
    System.out.println("Traitement du servlet : "+servletHttp);

    Headers reponseEntete = exchange.getResponseHeaders();
    reponseEntete.set("Content-Type", "text/pain");
    exchange.sendResponseHeaders(200, 0);

    // Tout servlet a besoin d'un objet dans lequel les methodes doGet et doPost
    //  du servlet y trouvera les mots clefs de la requete afin de realiser ses
    //  traitements
    //
    PrintStream ps = new PrintStream(outputRequest);
    BufferedReader br =  new BufferedReader(new InputStreamReader(inputRequest));

    MyHttpServlet  svreq = new MyHttpServlet(br,ps,servletHttp);
	
    // Recuperation du nom du servlet
    String nomServlet = svreq.getNomServlet();
	
    // Chargement dynamique de la classe de servlet en fonction de son nom
    // Ces classes sont trouvees par la classe LoadClassServelt
    //
    LoadClassServlet cl=null;
    cl = new LoadClassServlet(www);

    // Traitement du servlet
    // -------------------------------
    try
      {
        // Chargement de la classe de servlet
        Class c = cl.loadClass(nomServlet);
        if(c==null) 
          {
            // La classe n'a pas ete trouvee
            //
            System.out.println("Class not found:"+nomServlet);
            return;
          }

        // Instanciation de la classe de servlet
        MyServletAbstract sv = (MyServletAbstract)(c.newInstance());

        // Appel a la methode dans le cas de requete Http GET
        if (methodeRequete.equals("GET"))
          sv.doGet(svreq);

        // Appel a la methode dans le cas de requete Http POST
        else if (methodeRequete.equals("POST"))
          {
            System.out.println("POST POST");
            // Initialisation de la requete dans le cas POST
            //  (Lecture sur le socket de la requete, puis decodage)
            svreq.initPost();

            // Appel a la methode doPost
            sv.doPost(svreq);
          }
        else
          // Cas d'un type de requete non connu
          System.out.println("Type de transmission non connu");
      }
    catch (Exception e)
      {
        // En cas de pb de traitement du servlet
        System.out.println("Probleme dans traitement du servlet " + nomServlet);
        e.printStackTrace();
      }
  }



}//class
