package fr.cnam.horloge.controleur;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;

import fr.cnam.horloge.model.*;
import fr.cnam.horloge.controleur.*;

public class AdaptControleur implements ControleurHorloge
{
    ControleurHorlogeODInt od;

    public AdaptControleur(ControleurHorlogeODInt od)
    {
        this.od=od;
    }

    public ControleurHorlogeODInt getControleurHorlogeODInt()
    {
        return od;
    }

    // Changer le nom de l'horloge
    public void actionRenommerHorloge(String nomHorloge)
    {
        try{
            od.actionRenommerHorloge(nomHorloge);
        }catch(RemoteException ex){};
    }

    // Changer l'heure de l'horloge
    public void actionChangerHeureHorloge(HeureHorloge heure)
    {
        try{
            od.actionChangerHeureHorloge(heure);
        }catch(RemoteException ex){};
    }

    // Demande de notification
    public void actionNotifier()
    {
        try{
            od.actionNotifier();
        }catch(RemoteException ex){};
    }
        

    // Démarer l'horloge
    public void actionStartHorloge()
    {
        try{
            od.actionStartHorloge();
        }catch(RemoteException ex){};
    }

    // Arrêter l'horloge
    public void actionStopHorloge()
    {
        try{
            od.actionStopHorloge();
        }catch(RemoteException ex){};
    }

  // Retourne le modele de l'horloge controlé par le controleur
  public ModelHorloge getModelHorloge()
  {
    return null;  // Pas accessible en distant
  }
}