package fr.cnam.horloge.controleur;

import fr.cnam.horloge.model.HeureHorloge;
import fr.cnam.horloge.model.ModelHorloge;
import fr.cnam.horloge.controleur.ControleurHorloge;

// Interface d'utilisation du controleur d'horloge
public interface ControleurHorloge
{
    // Changer le nom de l'horloge
    public void actionRenommerHorloge(String nomHorloge);

    // Changer l'heure de l'horloge
    public void actionChangerHeureHorloge(HeureHorloge heure);

    // Demande de notification
    public void actionNotifier();

    // Dmarer l'horloge
    public void actionStartHorloge();

    // Arrter l'horloge
    public void actionStopHorloge();

    // Retourne le modele de l'horloge control par le controleur
    public ModelHorloge getModelHorloge();

}

