package fr.cnam.horloge.controleur;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.util.*;

import fr.cnam.horloge.model.*;
import fr.cnam.horloge.controleur.*;

public class ControleurHorlogeODImpl extends UnicastRemoteObject implements ControleurHorlogeODInt
{
    ControleurHorloge controleur;

    // Constructeur
    // Creation de l'OD RMI du controleur
    public ControleurHorlogeODImpl(ControleurHorloge controleur,
                                   int portRMI,
                                   int portRegistry) throws RemoteException
    {
        super(portRMI);
        try{
            this.controleur = controleur;
            Naming.rebind("rmi://localhost:"+portRegistry+"/CONTROLEUR_HORLOGE",this);
            System.out.println("Serveur CONTROLEUR_HORLOGE en ecoute  ... " + portRegistry);
        }catch(Exception ex){};
    }

    // Changer le nom de l'horloge
    public void actionRenommerHorloge(String nomHorloge) throws RemoteException
    {
        try{
            System.out.println("actionRenommerHorloge (distant)");
            controleur.actionRenommerHorloge(nomHorloge);
        }
        catch(Exception ex){};
    }

    // Changer l'heure de l'horloge
    public void actionChangerHeureHorloge(HeureHorloge heure) throws RemoteException
    {
        try{
            System.out.println("actionChangerHeureHorloge (distant)");
            controleur.actionChangerHeureHorloge(heure);
        }
        catch(Exception ex){};
    }

    // Notifier 
    public void actionNotifier() throws RemoteException
    {
        try{
            System.out.println("actionNotifier (distant)");
            controleur.actionNotifier();
        }
        catch(Exception ex){};
    }

    // Dmarrer le thread de l'horloge
    public void actionStartHorloge() throws RemoteException
    {
        try{
            System.out.println("actionStartHorloge (distant)");
            controleur.actionStartHorloge();
        }
        catch(Exception ex){};
    }

    // Arrter le thread de l'horloge
    public void actionStopHorloge() throws RemoteException
    {
        try{
            System.out.println("actionStopHorloge (distant)");
            controleur.actionStopHorloge();
        }
        catch(Exception ex){};
    }

    // Permet en RMI de s'abonner au changement du modele
    //
    public void addObserver(Remote observer) throws RemoteException
    {
        System.out.println("addObserver (distant)");

        // On cre l'observer dit "RMI" qui s'abonne puis qui appelera
        //   la mthode distante update de l'observer distant
        //
        ProxyObserverHorloge observerRMI = new ProxyObserverHorloge(observer);

        // On l'abonne
        System.out.println("ControleurHorlogeODImpl: addObserver du stub");
        controleur.getModelHorloge().getObservable().addObserver(observerRMI);
    }


    // ----------------------------------- PROGRAMME MAIN DU SERVEUR
    // Serveur RMI du controleur
    // --------------------------------------------------------------
    public static void main(String... args) throws Exception
    {
        int portRMI      = Integer.parseInt(args[0]);
        int portRegistry = Integer.parseInt(args[1]);

        // Creation de l'annuaire s'il n'existe pas dj
        try{
            LocateRegistry.createRegistry(portRegistry);
        } catch(Exception ex){};
        
        // Cration de l'OD du controleur
        //
        ControleurHorloge controleur = ControleurHorlogeImpl.getInstance();
        ControleurHorlogeODImpl controleurOD = new ControleurHorlogeODImpl(controleur,
                                                                           portRMI,
                                                                           portRegistry);
    }

}