package fr.cnam.horloge.controleur;

import java.rmi.*;
import java.rmi.server.*;

import fr.cnam.horloge.model.HeureHorloge;

// Interface d'utilisation du controleur d'horloge
public interface ControleurHorlogeODInt extends Remote
{
    // Changer le nom de l'horloge
    public void actionRenommerHorloge(String nomHorloge) throws RemoteException;

    // Changer l'heure de l'horloge
    public void actionChangerHeureHorloge(HeureHorloge heure) throws RemoteException;

    // Demande de notification
    public void actionNotifier() throws RemoteException;

    // Dmarer l'horloge
    public void actionStartHorloge() throws RemoteException;

    // Arrter l'horloge
    public void actionStopHorloge() throws RemoteException;

    // Ajouter un observer de manire distan
    //    observer est le stub de ObserverHorlogeOD
    public void addObserver(Remote observer) throws RemoteException;
}

