package fr.cnam.horloge.vue;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;

import fr.cnam.horloge.model.*;
import fr.cnam.horloge.controleur.*;
import fr.cnam.horloge.vue.*;

// Cet observer s'abonne au controleur distant de l'horloge et sera notifie quand
//  les etats de l'horologe seront modifies.
// Il est un objet distribue qui envoie son stub au controleur afin d'etre notifie.
// Cette classe adapte la classe ObserverHorloge 
//
public class AdaptObserverHorloge extends UnicastRemoteObject implements ObserverODInt
{
    Observer observer; // L'observer adapte

    // Constructeur
    public AdaptObserverHorloge(int portRMI,
                                Observer observer,
                                String hostControleur,int portControleur) throws RemoteException
    {
        super(portRMI);
        try{
            this.observer = observer;

            // Recuperation du stub de l'objet distribue
            Remote stub = UnicastRemoteObject.toStub(this);

            // On s'abonne aux changement des donnes du modele
            // Ici en RMI donc donner son stub en parametre
            //
            AdaptControleur adapt = (AdaptControleur)ControleurHorlogeImpl.getInstance();
            ControleurHorlogeODInt controleurRMI = adapt.getControleurHorlogeODInt();
            controleurRMI.addObserver(stub);  


        }catch(Exception ex){System.out.println(ex+"\nObserverHorlogeOD: erreur dans le constructeur \n"+ex);ex.printStackTrace();};
    }

    // Methode distante 
    //
    public void update(Observable observable, Object arg) throws RemoteException
    {
        // On relait la notification  l'objet cible
        observer.update(observable,arg);
    }
}

    