package fr.cnam.horloge.vue;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import fr.cnam.horloge.model.*;
import fr.cnam.horloge.controleur.*;

import fr.cnam.ihm.*;

// Classe de dfinition de la vue qui affiche l'heure de
//  l'horloge
//
// Cette classe implmente l'interface ObserverInt
//   afin d'tre prvenu quand une donne change dans le modele.
//
// La vue n'est plus lie au controleur mais a l'observer 
//
public class VueAfficherHeureHorloge implements ObserverInt, FormulaireInt
{
  private Formulaire             form;             // L'ihm de la vue
  private ControleurHorloge controleur;
  
  // Constructeur
  public VueAfficherHeureHorloge()
  {
    // Recuperation du controleur
    controleur = ControleurHorlogeImpl.getInstance();
    
    // Creation du formulaire
    form = new Formulaire("HORLOGE",this,300,100);
    form.setTailleFonte(20);
    form.setHeightText(30);
    form.addText("NOM","Nom",false,"");
    form.addText("HEURE","Heure",false,"");

    // Abonnement au modele gere par le controleur
    ControleurHorlogeImpl.sabonner(this);
  }

    // Affichage de l'horloge.
    // 
    public void afficher()
    {
        form.afficher(10,10);

        // Pour initialiser l'IHM lors de son affichage
        controleur.actionNotifier();
    }

    // Methode qui est appele si une donne change dans le modle de l'horloge
    //  via un observer
    // Les nouvelles valeurs de l'horloge sont passees en parametre de la methode
    //  de notification. La convention est un Arraylist contenant le nom de l'information
    //  qui a change suivi de sa valeur
    //     ["NOM"   , nom]
    //     ["HEURE" , heure]
    // 
    public void update(Observable observable, Object arg)
    {
        if (arg!=null)
            {
                ArrayList targ = (ArrayList)arg;
                String info = (String)(targ.get(0));
                if (info.equals("NOM"))
                    {
                        String nomHorloge;
                        nomHorloge = (String)(targ.get(1));
                        form.setValeurChamp("NOM",nomHorloge);
                    }
                if (info.equals("HEURE"))
                    {
                        HeureHorloge heureHorloge;
                        heureHorloge = (HeureHorloge)(targ.get(1));
                        String heureStr;
                        if (heureHorloge != null)
                            heureStr = String.format("%02d %02d %02d",
                                                     heureHorloge.getHeure(),
                                                     heureHorloge.getMinute(),
                                                     heureHorloge.getSeconde());
                        else
                            heureStr = String.format("heure inconnue");
                        form.setValeurChamp("HEURE",heureStr);
                    }
            }
    }

    // Pas d'acton dans cette vue
    //
    public void submit(Formulaire form,String nom)
    {
    }
}

