package hello;

import java.io.*;
import org.omg.CORBA.*;

public class Client {
  public static void main( String args[] ) {
    if( args.length != 1 ) {
      System.out.println( "Usage: jaco hello.Client <ior_file>" );
      System.exit( 1 );
    }
    try {
      File f = new File( args[ 0 ] );
						
      //check if file exists
      if( ! f.exists() ) {
        System.out.println("File " + args[0] + 
                           " does not exist.");
                
        System.exit( -1 );
      }
            
      //check if args[0] points to a directory
      if( f.isDirectory() ){
        System.out.println("File " + args[0] + 
                           " is a directory.");
                
        System.exit( -1 );
      }
						
      // Initialisation de l'ORB
      ORB orb = ORB.init( args, null );
						
      // Rcuparation de la rfrence CORBA  partir de l'IOR
      BufferedReader br =
        new BufferedReader( new FileReader( f ));
      org.omg.CORBA.Object obj = 
        orb.string_to_object( br.readLine() );
      br.close();

      // Rcupration du servant
      GoodDay goodDay = GoodDayHelper.narrow( obj );

      // Utilisation du servant
      goodDay.compteur(100);
      while(true)
        {
          // invoke the operation again and print the wide string result
          String str = goodDay.hello_world( "J. Laforgue ");
          System.out.println(str);
          try{Thread.sleep(1000);}catch(Exception ex){};
        }

    }
    catch( Exception ex ) 
      {
        ex.printStackTrace();
      }
  }
}

