package hello;
import java.io.*;
import org.omg.CORBA.*;
import org.omg.PortableServer.*;

public class Server {
  public static void main(String[] args)  {
    if( args.length != 1 ) {
      System.out.println("Usage: jaco hello.Server <ior_file>");
      System.exit( 1 );
    }
    try {            
      //initialisation de l'ORB
      ORB orb = ORB.init( args, null );
						
      //Cration du POA
      POA poa = 
        POAHelper.narrow( 
                         orb.resolve_initial_references( "RootPOA" ));

      // Activation du POA manager
      poa.the_POAManager().activate();

      // Cration du servant
      GoodDayImpl goodDayImpl = new GoodDayImpl( "CNAM NFA032" );  
						
      // Cration de la rfrence CORBA (IOR)
      org.omg.CORBA.Object obj = 
        poa.servant_to_reference( goodDayImpl );
						
      // Ecrire l'IOR dans un fichier
      PrintWriter pw = 
        new PrintWriter( new FileWriter( args[ 0 ] ));
      pw.println( orb.object_to_string( obj ));
						
      pw.flush();
      pw.close();
						
      // Attentes des requetes
      orb.run();
    }
    catch( Exception e ) 
      {
        System.out.println( e );
      }
  }
}

