package hello_with_ns;

import java.io.*;

import org.omg.CORBA.*;
import org.omg.PortableServer.*;

import org.omg.CosNaming.*;

public class Server 
{
    public static void main(String[] args) 
    {
        try 
            {            
                //Initialisation de l'ORB
                ORB orb = ORB.init( args, null );

                //Cration du POA
                POA poa =  
                    POAHelper.narrow( 
                       orb.resolve_initial_references( "RootPOA" ));

                //Activation du POA
                poa.the_POAManager().activate();

                //On rcupre le Naming Services comme un servant 
                //  prdfini dans l'ORB
                // Rcupration du Naming contexte root
                NamingContextExt contextRoot = 
                    NamingContextExtHelper.narrow(
                       orb.resolve_initial_references("NameService"));

                // Cration d'un sous contexte dans le contexte root
                NameComponent[] name = new NameComponent[1];
                name[0] = new NameComponent("sub","context");
                NamingContextExt subContext =
                    NamingContextExtHelper.narrow( 
                       contextRoot.bind_new_context( name ));
                
                //Cration du servant dans le contexte root
                GoodDayImpl goodDayImpl = new GoodDayImpl( "Somewhere" );  
    
                //Cration de la rfrene de l'objet
                org.omg.CORBA.Object obj = 
                    poa.servant_to_reference( goodDayImpl );

                //Enreistrement de la rfrence du servant dans l'annuaire
                contextRoot.bind( contextRoot.to_name("HELLO"), obj);


                // Pour faire un test
                //Cration d'un autre servant dans le sous contexte "sub.context"
                GoodDayImpl goodDayImpl2 = new GoodDayImpl( "Somewhere2" );  
    
                //Cration de la rfrene de l'objet
                org.omg.CORBA.Object obj2 = 
                    poa.servant_to_reference( goodDayImpl2 );

                //Enreistrement de la rfrence du servant dans l'annuaire
                subContext.bind( subContext.to_name("HELLO"), obj2);  
                // Le mme nom peut tre utilis dans deux contextes diffrents

                //Attente des requtes clientes
                orb.run();
            }
        catch( Exception e ) 
            {
                System.out.println( e );
            }
    }
}
