package devise;

import java.io.*;
import org.omg.CORBA.*;

import org.omg.CosNaming.*;

import devise.*;


public class Client 
{
    public static void main( String args[] ) 
    {
        try 
						{
                // Flot de lecture du clavier
                java.io.DataInputStream in = new java.io.DataInputStream(System.in);
                
								// initialize the ORB.
								ORB orb = ORB.init( args, null );

								// Rcupration du Naming Service
								NamingContextExt nc = 	
										NamingContextExtHelper.narrow(orb.resolve_initial_references("NameService"));

                
                // Acces  l'OD qui contient la liste des devises et leurs caractristiques
                Devises lesdevises = DevisesHelper.narrow(nc.resolve(nc.to_name("DEVISES")));
                DeviseData[] tabdevises = lesdevises.getDevises();

                while (true)
                    {
                        // Les devises possibles
                        //
                        for(int i=0;i<tabdevises.length;i++)
                            {
                                System.out.println(String.format("%d : %10s vers %10s (taux:%.2f)",
                                                                 i,tabdevises[i].nom1,tabdevises[i].nom2,tabdevises[i].taux));
                            }
                        
                        // Choix de la devise
                        System.out.print("Choix de la devise:");
                        int num = Integer.parseInt(in.readLine());
                        
                        DeviseData devisedata = tabdevises[num];

                        // Accs au servant de la devise
                        DeviseInt devise =  
                            DeviseIntHelper.narrow(nc.resolve(nc.to_name(devisedata.nom1+"_"+devisedata.nom2)));
                        
                        // Les informations de la devise
                        DeviseData infos = devise.getDeviseData();
                        System.out.println( "Conversion de " + 
                                            infos.nom1 + " vers " + infos.nom2 + " avec un taux de:" + infos.taux);
                        System.out.println( "Conversion de " + 
                                            devise.getNom1() + " vers " + devise.getNom2() + " avec un taux de:" + devise.getTaux() );
                        
                        double val,resultat;
            
                        System.out.print(devisedata.nom1+" : ");
                        System.out.flush();
                        val = Double.parseDouble(in.readLine());
                        resultat = devise.convertir1(val);
                        System.out.println(devisedata.nom2+" : "+resultat);
            
                        System.out.print(devisedata.nom2+" : ");
                        System.out.flush();
                        val = Double.parseDouble(in.readLine());
                        resultat = devise.convertir2(val);
                        System.out.println(devisedata.nom1+" : "+resultat);

                    }
						}
        catch( Exception ex ) 
						{
								ex.printStackTrace();
						}
    }
}

