package devise;

import java.io.*;

import org.omg.CORBA.*;
import org.omg.PortableServer.*;

import org.omg.CosNaming.*;

import devise.*;

public class Server 
{
    public static void main(String[] args) 
    {
        try 
						{            
								//init ORB
								ORB orb = ORB.init( args, null );

								//init POA
								POA poa = 
										POAHelper.narrow( orb.resolve_initial_references( "RootPOA" ));

								poa.the_POAManager().activate();

								NamingContextExt nc = NamingContextExtHelper.narrow(
                             orb.resolve_initial_references("NameService"));


                // =====================================================================
                // Création de la table des devises
                DesDevisesOD lesDevises = new DesDevisesOD();
                nc.bind( nc.to_name("DEVISES"),
                         poa.servant_to_reference(new DevisesPOATie(lesDevises)) );
                

                // =====================================================================
								// Creation de la premiere devise
								DeviseIntPOATie deviseod = new DeviseIntPOATie(new DeviseOD( "EURO","DOLLAR",1.23 ));
    
								// create the object reference
								org.omg.CORBA.Object obj = 
										poa.servant_to_reference( deviseod );

                // Enregistrement dans l'annuaire
                System.out.println("Enregistrement de la devise EURO_DOLLAR");
								nc.bind( nc.to_name("EURO_DOLLAR") , obj);

                // Mise à jour du tableau des devises
                lesDevises.ajouterDevise("EURO","DOLLAR",1.23);

                // =====================================================================
                // Creation de la deuxième devise
                String nom1 = "EURO";
                String nom2 = "FRANC";
                double taux = 6.5;
                DeviseIntPOATie devise = new DeviseIntPOATie(new DeviseOD(nom1,nom2,taux));
                nc.bind( nc.to_name(nom1+"_"+nom2),poa.servant_to_reference(devise) );

                // Mise à jour du tableau des devises
                lesDevises.ajouterDevise(nom1,nom2,taux);


								// wait for requests
                System.out.println("ORB> run");
								orb.run();
						}
        catch( Exception e ) 
						{
								System.out.println( e );
						}
    }
}
