package my_event;

import java.io.*;

import org.omg.CORBA.*;
import org.omg.PortableServer.*;

import org.omg.CosNaming.*;
import org.omg.CosEventChannelAdmin.*;
import org.omg.CosEventComm.*;
import org.jacorb.events.*;

class Producteur extends PushSupplierPOA
{
  private EventChannel       _ec;
  private org.omg.CORBA.ORB  _orb;
  private ProxyPushConsumer  _consommateurs;

  public Producteur(org.omg.CORBA.ORB orb,
                    EventChannel ec)
  {
    _ec=ec;
    _orb=orb;

    try{
      // On obtient les proxy des consommateurs suivant le modle push
      SupplierAdmin supplierAdmin = _ec.for_suppliers();
      _consommateurs = supplierAdmin.obtain_push_consumer();
						
      // On connecte le producteur aux proxy des consommateur suivant le modle push
      _consommateurs.connect_push_supplier( _this(_orb) );
    }catch(Exception e){}
  }

  public void disconnect_push_supplier ()
  {
    System.out.println ("Supplier disconnected");
  }

  public void poster(String message)
  {
    try{

      Any any = _orb.create_any();
      any.insert_string(message);
      System.out.println("*** Pushing event");

      _consommateurs.push( any );

    }catch(Exception e){};
  }
}

public class Producter 
{
		
  public static void main(String[] args) 
  {
    try 
      {            
        //Initialisation de l'ORB
        ORB orb = ORB.init( args, null );

        //Cration du POA
        POA poa = 
          POAHelper.narrow( orb.resolve_initial_references( "RootPOA" ));

        //Activation du POA
        poa.the_POAManager().activate();

        //Rcupration du Naming contexte
        NamingContextExt nc = NamingContextExtHelper.narrow(orb.resolve_initial_references("NameService"));

        // Rcupration du canal d'vnement
        org.omg.CosEventChannelAdmin.EventChannel e = EventChannelHelper.narrow(nc.resolve(
                                                                                           nc.to_name("eventchannel.example")));

        // Cration d'un producteur
        Producteur p = new Producteur(orb,e);

        // On poste 100 vnements
        for(int i=1;i<100;i++)
          p.poster("EXEMPLE DE MESSAGE " + i );

      }
    catch( Exception e ) 
      {
        System.out.println( e );
      }
  }
}
