// Exemple du DP Proxy mais en utilisant un DynamicProxy
//
import java.lang.reflect.*;

public class ExempleCh08_01
{

  public static void main(String[] args)
  {
    Applicatif  appImp1 = new ApplicatifImp();
    Ihm ihm1 = new Ihm(appImp1);
    System.out.println("SANS LE PROXY:");
    ihm1.exemple();


    Applicatif  appImp2 = new ApplicatifImp();
    
    Applicatif appProxy = (Applicatif)
      Proxy.newProxyInstance(Applicatif.class.getClassLoader(),
                             new Class<?>[] { Applicatif.class },
                             new ApplicatifProxyInvocationHandler(appImp2,"LAFORGUE"));
        
    // Exemple d'utilisation du Proxy 
    // Separation de l'ihm et de son applicatif

    Ihm ihm2 = new Ihm(appProxy);
    System.out.println("\nAVEC LE PROXY:");
    ihm2.exemple();
  }
}

class Ihm 
{
  private Applicatif app;
    
  public Ihm(Applicatif app)
  {
    this.app = app;
  }

  public void exemple()
  {
    System.out.println("------ exemple -----");
    int x = app.getX();
    int y = app.getY();
    app.setX(100);
    app.setY(200);
    app.setX(2000);
    app.getX();
    app.traitement();
  }
}

interface Applicatif
{
  public int getX();
  public int getY();
  public void setX(int x);
  public void setY(int y);
  public void traitement();
}

class ApplicatifImp implements Applicatif
{
  private int x;
  private int y;

  public ApplicatifImp()
  {
    x=10;
    y=20;
  }

  public int getX(){System.out.println("getX: "+x);return x;}
  public int getY(){System.out.println("getY: "+y);return y;}
  public void setX(int x){System.out.println("setX: "+x);this.x=x;}
  public void setY(int y){System.out.println("setY: "+y);this.y=y;}
    
  public void traitement()
  {
    System.out.println("traitement");
  }
}

class ApplicatifProxyInvocationHandler implements InvocationHandler
{

  private Applicatif app;
  private String     qui;

  public ApplicatifProxyInvocationHandler(Applicatif app, String qui)
  {
    this.app=app;
    this.qui = qui;
  }

  public Object invoke(Object proxy, Method method, Object[] args)
  {
    String marge="                    ";

    try{
      System.out.println(marge+"Appel a "+method.getName() + " par "+qui+"  avec les paramtres: ");
      if (args==null) System.out.println(marge+"pas de paramtre");
      else for(int i=0;i<args.length;i++)
             System.out.println(String.format("%sparam %2d : %s",marge,i,args[i]));
      

      if ( (method.getName().equals("setX")) &&
           ( ((Integer)args[0]).intValue() > 1000 ) )
        {
          System.out.println(marge+"INTERDICTION DE CHANGER X > 1000");
          return null;
        }
      else
        return method.invoke(app,args);
  }
  catch(Exception ex) {throw new RuntimeException("Erreur invoke");}
}
}

