//Exemple de chargement et d'execution d'une classe qui se trouve sur un serveur HTTP.<br>Il faut que au preallable un serveur HTTP soit lance. Par exemple EasyPHP. Le web-root est le repertoire "classes" de l'exemple<br>Exemple de chargement et d'execution d'une classe qui se trouve sur un serveur de socket.
//
import java.lang.*;
import java.lang.reflect.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class ExempleCh08_02Cas3
{
    public static void main(String... args) throws Exception
    {
        System.out.println("Execution de ExempleCh08_02 CAS 3");

        // Creation du chargeur de classe sur une adresse URL
        //
        URL[] urls = new URL[2];
        urls[0] = new URL("http://127.0.0.1:8888/edsa-Ch08_02_Cas3/");
        urls[1] = new URL("http://127.0.0.1:8080/edsa-Ch08_02_Cas3/");
        
        // Chargement de la classe Bonjour et execution de la methode main
        //
        while (true)
            {

                // Si on veut etre dynamique, on met le Class Loader
                //   dans la boucle
                //
                URLClassLoader classLoader = URLClassLoader.newInstance(urls);

                // Chargt classe Bonjour
                //
                try{
                    Class<?> classe = Class.forName("Bonjour", true, classLoader);
                    
                    // Appelle methode main
                    //
                    Method m = classe.getMethod("main",new Class[]{String[].class});
                    
                    String[] tabargs = new String[2];
                    tabargs[0] = args[0];
                    tabargs[1] = args[1];
                    Object[] params = new Object[1];
                    params[0] = tabargs;
                    m.invoke(null, params);
                }catch(Exception ex){System.out.println("Pb chargement. On recommence");}
                
                try{Thread.sleep(2000);}catch(Exception ex){};
            }
    }
}
