
import java.lang.*;
import java.net.*;
import java.io.*;
import java.util.*;

// Classe de dfinition d'un serveur de socket qui est utilis comme chargeur de classe
//
public class ServerClass
{
    public static void main(String... args) throws Exception
    {
        System.setSecurityManager(new SecurityManager());

        // Creation du serveur de socket Java
        ServerSocket sos = new ServerSocket(9100);

        while (true)
            {
                System.out.println("Attente...");
                Socket soc = sos.accept();
                System.out.println("Socket accroche");
                
                // Creation du flot d'ecriture: reponses du serveur
                DataOutputStream  dos = new DataOutputStream(soc.getOutputStream());
                
                // Creation du flot de lecture: requetes au serveur
                DataInputStream is = new DataInputStream(soc.getInputStream());
                
                // Nom du fichier de classe demandé
                String fichier = is.readUTF();
                if (fichier==null)
                    System.out.println("Requète nulle !!!");
                else
                    {
                        System.out.println("Envoi de la classe: "+fichier);

                        // Lecture du fichier
                        File fic;
                        FileInputStream fis;
                        fic = new File("../classes",fichier);
                        fis = new FileInputStream(fic);
                        
                        byte[] donnees = new byte[(int) fic.length()];
                        fis.read(donnees);
                        fis.close();

                        // Ecriture du fichier sur le socket
                        dos.writeInt(donnees.length);
                        dos.write(donnees);
                        
                    }
                // Fermeture du socket
                soc.close();
            }
    }
}
