import java.util.*;
// ------------------------------------
public class ProxyApp implements AppInt
{
    private ObservableApp obs;
    private App app;

    public ProxyApp(App app)
    {
        this.obs = new ObservableApp();
        this.app = app;
    }
    
    public void setEtat1(int v)
    {
        app.setEtat1(v);
        obs.setChanged();
        obs.notifyObservers(app.getEtat1());
    }

    public void setEtat2(String v)
    {
        app.setEtat2(v);
        obs.setChanged();
        obs.notifyObservers(app.getEtat2());
    }

    public int    getEtat1(){return app.getEtat1();}
    public String getEtat2(){return app.getEtat2();}

    public String getNomApplicatif(){return app.getNomApplicatif();}

    public void configurer(Observer observer)
    {
        obs.addObserver(observer);
        app.configurer(observer); // Ici le traitement est vide
    }

    public void traitement(AppInt app)
    {
        this.app.traitement(this);
    }
}

