import java.util.*;
import java.lang.reflect.*;

// ------------------------------------
public class ServiceVirtualProxyApp implements AppInt
{
    private ObservableApp obs;
    private AppInt app;
    private ClassLoader loader;

    public ServiceVirtualProxyApp(String nomClasseApp,ClassLoader loader)
    {
        this.loader = loader;
        
        try{
            // Construction de l'applicatif dynamiquemment
            Class classe = loader.loadClass(nomClasseApp);
            Class[] typeDesArguments = new Class[]{}; 
            Constructor cons = 
                classe.getConstructor(typeDesArguments); 
            Object[] parametres = new Object[]{}; // sans paramètre

            // Creation de l'app 
            app = (AppInt)cons.newInstance(parametres); 

            obs = new ObservableApp();

        }catch(Exception ex){ ex.printStackTrace();}
    }
    
    public void setEtat1(int v)
    {
        app.setEtat1(v);
        obs.setChanged();
        obs.notifyObservers(app.getEtat1());
    }

    public void setEtat2(String v)
    {
        app.setEtat2(v);
        obs.setChanged();
        obs.notifyObservers(app.getEtat2());
    }

    public int getEtat1(){return app.getEtat1();}
    public String getEtat2(){return app.getEtat2();}

    public String getNomApplicatif(){return app.getNomApplicatif();}

    public void configurer(Observer observer)
    {
        obs.addObserver(observer);
        app.configurer(observer); // Ici le traitement est vide
    }

    public void traitement(AppInt app)
    {
        this.app.traitement(this);
    }
}

