// Pour le cours sur le DynamicProxy
// Utilisation d'un DynamicProxy pour lier n'importe quel classe de modele applicatif avec les vues qui doivent etre notifiees suite a la modification du modele
// Les classes de modele applicative sont chargees dynamiquement sans passer par le CLASSPATH de la JVM.
// Ici, les classes sont dans un repertoire separe.
// Le dynamic proxy de notification est generique. Il s'adapte a toute classe.
//
// On empile plusieurs proxy :
//   - un proxy qui loggue les appels aux methodes de l'applicatif dans un fichier
//   - un proxy qui verifie l'identification (user,password) de l'utilisateur de l'applicatif
//
import java.util.*;
import java.lang.reflect.*;

public class ExempleCh08_03c
{
    public static void main(String[] args)
    {

        // Exemple de l'utilisation d'un proxy pour notifier les changements
        //  d'etat d'un applicatif
        //
        AppInt app = (AppInt) Proxy.newProxyInstance( ClassLoader.getSystemClassLoader(),
                                                      new Class[] { AppInt.class },
                                                      new MyServiceHandler("App") );
        
        System.out.println("classe_proxy : "+ app.getClass().getName() );
        
        Utilisateur u1 = new Utilisateur("U1",app);
        Utilisateur u2 = new Utilisateur("U2",app);
        
        app.traitement(app);


        // Exemple de l'utilisation du meme proxy que precedemment mais
        //  applique a un autre applicatif totalement different (classe, interface)
        //
        System.out.println("==================================");

        AppInt2 app2 = (AppInt2) Proxy.newProxyInstance( ClassLoader.getSystemClassLoader(),
                                                         new Class[] { AppInt2.class },
                                                         new MyServiceHandler("App2") );
        System.out.println("classe_proxy : "+ app2.getClass().getName() );

        Utilisateur2 u3 = new Utilisateur2("U3",app2);
        app2.unautretraitement(app2);
        

        // Exemple dans lequel on "empile" un autre proxy sur le 1er proxy.
        // Ce nouveau proxy journalise dans un fichier l'appel a toutes les methodes
        //  de l'applicatif
        //
        System.out.println("==================================");
        AppInt appBis = (AppInt) Proxy.newProxyInstance( ClassLoader.getSystemClassLoader(),
                                                          new Class[] { AppInt.class },
                                                          new ProxyLogHandler(app) );
        appBis.traitement(appBis);


        // Exemple dans lequel on "empile" un autre proxy sur le proxy precedent
        // Ce nouveau proxy vrifie l'identite du programme client
        //  de l'applicatif
        //
        System.out.println("==================================");
        ProxyIdentification pi = new ProxyIdentification(appBis);
        AppInt appTri = (AppInt) Proxy.newProxyInstance( ClassLoader.getSystemClassLoader(),
                                                          new Class[] { AppInt.class },
                                                          pi );

        System.out.println("--------------  jacques");
        pi.setIdentification("jacques","12345");
        appTri.traitement(appTri);

        System.out.println("--------------  denis");
        pi.setIdentification("denis","abcdef");
        appTri.traitement(appTri);

        System.out.println("--------------  robert");
        pi.setIdentification("robert","abcdef");
        appTri.traitement(appTri);
    }
}
