import java.util.*;
import java.lang.reflect.*;

// Classe de defintion du service qui permet la notification
//   des changements d'etat de l'applicatif
//
public class MyServiceHandler implements InvocationHandler
{
    private ObservableApp obs;
    private Object app; ///// AppInt app;

    public MyServiceHandler(String nomClasseApp)
    {
        try{
            // Construction de l'applicatif dynamiquemment
            Class classe = Class.forName(nomClasseApp,true,
                                         ClassLoader.getSystemClassLoader()); 
            // On utile le loader de classe de la JVM qui a ete surcharge lors du
            // lancement de la JVM java : -Djava.system.class.loader=ChargeurDefaut 

            Class[] typeDesArguments = new Class[]{}; 
            Constructor cons = 
                classe.getConstructor(typeDesArguments); 
            Object[] parametres = new Object[]{}; // sans paramètre

            // Creation de l'app 
            this.app = cons.newInstance(parametres);////(AppInt)cons.newInstance(parametres); 

            this.obs = new ObservableApp();

        }catch(Exception ex){ ex.printStackTrace();}
    }

    public Object invoke(Object proxy,
                         Method m,
                         Object[] args) throws Throwable
    {
        String prefixe = m.getName().substring(0,3);

        if(prefixe.equals("get"))
            return m.invoke(app, args);
        else if (prefixe.equals("set"))
            {
                // Appel du setteur
                m.invoke(app,args);

                // Appel du getteur
                String nomGetteur = "get"+m.getName().substring(3);
                
                Method getteur = app.getClass().getDeclaredMethod(nomGetteur);
                Object val = getteur.invoke(app);

                obs.setChanged();
                obs.notifyObservers(val);

                return null;
            }
        else if (m.getName().equals("configurer"))
            {
                obs.addObserver((Observer)args[0]);
                m.invoke(app, args);
                
                return null;
            }
        else 
            {
                return m.invoke(app, args);
            }
    }
}
