import java.util.*;
import java.io.*;
import java.lang.reflect.*;

// ------------------------------------
// Un PROXY qui loggue les appels a toutes les methodes 
//  de l'applicatif dans le fichier log.txt
//
public class ProxyLogHandler implements InvocationHandler
{
    private Object app;
    private PrintStream ps;

    public ProxyLogHandler(Object app)
    {
        try{
            ps = new PrintStream(new FileOutputStream("../log.txt"));
            this.app=app;
        }catch(Exception ex){};
    }

    public Object invoke(Object proxy,
                         Method m,
                         Object[] args) throws Throwable
    {
        ps.println(">> "+app.getClass().getName()+":"+m.getName());
        ps.flush();
        return m.invoke(app, args);
    }
}
