import java.util.*;
import java.io.*;
import java.lang.reflect.*;

// ------------------------------------
// Un PROXY qui verifie l'identification de l'utilisateur
//  de l'applicatif
//
public class ProxyIdentification implements InvocationHandler
{
    private AppInt app;
    private String user;
    private String password;
    private Hashtable<String,String> base;

    public ProxyIdentification(AppInt app)
    {
        this.app=app;
        user="";
        password="";
        // La base des users et mots de passe
        base=new Hashtable<String,String>();
        base.put("jacques","12345");
        base.put("denis","abcdef");
        base.put("robert","ABCDEF");
    }
    
    public void setIdentification(String user,String password){
        this.user=user;
        this.password=password;
    }

    public Object invoke(Object proxy,
                         Method m,
                         Object[] args) throws Throwable
    {
        if ( user.equals("") || password.equals("") )
                  erreur(m);
        if (base.get(user)!=password) erreur(m);
        return m.invoke(app, args);
    }
    
    public void erreur(Method m)
    {
        throw new ProxyIdentificationException("Erreur d'identification : "+user+":"+m.getName());
    }
}
