package fr.cnam.myrmi;

import java.io.*;
import java.net.*;
import java.util.*;

public class MyLocateRegistry implements MyRegistry
{
  private ServerSocket ssoc;
  private Hashtable<String,MyRemote> elements;

  public MyLocateRegistry(int port) throws Exception
  {
    elements = new Hashtable<String,MyRemote>();

    try{
      ssoc = new ServerSocket(port);

      Runnable runnable = new Runnable(){
          public void run(){
            try{
              while (true){
                System.out.println("MyLocateRegistry>Attente accept...");
                Socket soc = ssoc.accept();
                OutputStream os=soc.getOutputStream();
                ObjectOutputStream oos=new ObjectOutputStream(os);
                InputStream is=soc.getInputStream();
                ObjectInputStream ois=new ObjectInputStream(is);

                String ope = (String)ois.readObject();
                if (ope.equals("lookup")){
                  System.out.println("MyLocateRegistry>lookup>debut: ");
                  String name = (String)ois.readObject();
                  MyRemote stub = elements.get(name);
                  oos.writeObject(stub);
                  System.out.println("MyLocateRegistry>lookup>fin: "+name);
                }
                if (ope.equals("rebind")){
                  String name = (String)ois.readObject();
                  MyRemote obj = (MyRemote)ois.readObject();
                  elements.put(name,obj);
                  oos.writeObject("OK");
                }
              }
            }catch(Exception ex){ex.printStackTrace();}
                    	
                    	
                        
          }};
      Thread t = new Thread(runnable);
      t.start();
            
    }catch(Exception ex){throw new Exception(ex.toString());}
  }

  public static MyRegistry createRegistry(int port) throws Exception
  {
    return new MyLocateRegistry(port);
  }

  public MyRemote lookup(String name)
  {
    System.out.println("lookup: "+name);
    return elements.get(name);
  }

  public void rebind(String name, MyRemote obj)
  {
    System.out.println("rebind: "+name);
    elements.put(name,obj);  // On est local donc directement l'objet OD
  }

}