package fr.cnam.myrmi;

import java.lang.reflect.*;
import java.net.*;

public class MyUnicastRemoteObject extends MyRemoteObject 
{
  private int port;

  public MyUnicastRemoteObject(int port)
  {
    super(port);
    this.port=port;
    exportObject();
  }

  public MyRemoteObject exportObject()
  {
    MyRMIServerSocket.getInstance(port).addRemoteObject(this);
    return this;
  }

  public MyRemote toStub()
  {
    Class<?>[] interfaces = this.getClass().getInterfaces();

    Object proxy = java.lang.reflect.Proxy.newProxyInstance(this.getClass().getClassLoader(),
                                                            interfaces,
                                                            new MyRemoteInvokerHandler(getObjId().getHashCode(),
                                                                                       getObjId().getHost(),
                                                                                       getObjId().getPort()) );
    return ((MyRemote)proxy);
  }
}