package fr.cnam.myrmi;

import java.util.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;

public class MyRMIServerSocket 
{
  private static Hashtable<Integer,MyRMIServerSocketThread> ssocs;
  private ArrayList<MyRemoteObject> skeltons;
  private static MyRMIServerSocket myssoc;

  static public MyRMIServerSocket getInstance(int port)
  {
    if (myssoc==null)
      {
        myssoc = new MyRMIServerSocket();
        ssocs = new Hashtable<Integer,MyRMIServerSocketThread>();
      }

    if (ssocs.get(port)==null)
      {
        MyRMIServerSocketThread s = new MyRMIServerSocketThread(port);
        ssocs.put(port,s);
      }
    
    return myssoc;
  }
  
  private  MyRMIServerSocket()
  {
    skeltons = new ArrayList<MyRemoteObject>();
  }
  
  synchronized public void addRemoteObject(MyRemoteObject sk)
  {
    System.out.println("Ajout d'un skelton: "+sk.getObjId().getHashCode());
    skeltons.add(sk);
  }

  ArrayList<MyRemoteObject> getSkeltons()
  {
    return skeltons;
  }

}

class MyRMIServerSocketThread implements Runnable
{
  private ServerSocket ssoc;
  private int port;
    
  public MyRMIServerSocketThread(int port)
  {
    try{
      ssoc = new ServerSocket(port);
    }catch(Exception ex){ex.printStackTrace();}
    Thread t = new Thread(this);
    t.start();
  }
  public void run()
  {
    try{
      while (true)
        {
          Socket soc = ssoc.accept();
          OutputStream os=soc.getOutputStream();
          ObjectOutputStream oos=new ObjectOutputStream(os);
          InputStream is=soc.getInputStream();
          ObjectInputStream ois=new ObjectInputStream(is);
            
          Integer hashCodeRemote = (Integer)(ois.readObject());
          String methode = (String)(ois.readObject());
            
          MyRMIServerSocket server = MyRMIServerSocket.getInstance(port);
          MyRemoteObject skelton = null;
          for(MyRemoteObject sk : server.getSkeltons())
            if (sk.getObjId().getHashCode() == hashCodeRemote.intValue())
              skelton = sk;
                    
          if(skelton!=null)
            {
              System.out.println(">>invoke de "+methode);
                            
              Integer onbarg = (Integer)(ois.readObject());
              int nbarg = onbarg.intValue();
              if (nbarg!=0)
                {
                  Object[] args = (Object[])(ois.readObject());
                  Class<?>[] classes = new Class<?>[args.length];
                  int i=0;
                  for(Object o:args) classes[i++]=o.getClass();
                                    
                  Method m = skelton.getClass().getMethod(methode,classes);
                  Object rep = m.invoke(skelton,args);
                  if (rep==null)
                    oos.writeObject(new Integer(0));
                  else
                    oos.writeObject(rep);
                }
              else
                {
                  Method m = skelton.getClass().getMethod(methode);
                  Object rep = m.invoke(skelton);
                  if (rep==null)
                    oos.writeObject(new Integer(0));
                  else
                    oos.writeObject(rep);
                }
            }
          else
            {
              System.out.println("ERREUR: skelton non trouve: "+hashCodeRemote.intValue());
            }
        }
    }catch(Exception ex)
      {
        System.out.println("Erreur dans MyRMIServerSocketThread : run");
        System.out.println(ex);
        ex.printStackTrace();
      }
  }
}
