package fr.cnam.myrmi;

import java.lang.reflect.*;
import java.io.*;
import java.net.*;

public class MyRemoteInvokerHandler implements InvocationHandler, Serializable
{
    private int hashCode;
    private String host;
    private int port;

    public MyRemoteInvokerHandler(int hashCode,String host,int port)
    {
        this.hashCode = hashCode;
        this.host = host;
        this.port = port;
    }

    public Object invoke(Object proxy,
                         Method m,
                         Object[] args) throws Throwable
    {
        Socket soc;
        if (host.equals("localhost")) soc = new Socket(InetAddress.getLocalHost(),port);
        else soc = new Socket(InetAddress.getByName(host),port);
        OutputStream os=soc.getOutputStream();
        ObjectOutputStream oos=new ObjectOutputStream(os);
        InputStream is=soc.getInputStream();
        ObjectInputStream ois=new ObjectInputStream(is);
        
        oos.writeObject(new Integer(hashCode));
        oos.writeObject(m.getName());
        if (args==null) oos.writeObject(new Integer(0));
        else oos.writeObject(new Integer(args.length));
        oos.writeObject(args);

        Object rep = ois.readObject();
        soc.close();
        
        return rep;
    }
}
