import java.util.*;
import java.awt.Point;

import fr.cnam.ihm.*;
import fr.cnam.tore.*;

// Exemple de la programmation des agents
//
public class ExempleAgent implements FormulaireInt
{
  CanvasIHM grille;     // La grille qui visualise le deplacement des agents
  int mode;             // Mode de deplacement de l'agent
  Point pointCourant;   // Point courant designe dans la grille
  Tore espace;          // L'espace mathematique de tore
  Random  rdm;          // Fonction aleatoire
  ArrayList<Agent> population; // Population contenant tous les agents
  int numCourant=0;     // Chaque agent a un numero unique

  // Constructeur
  //
  public ExempleAgent()
  {
    mode=1;  // Mode par defaut : deplacmeent aleatoire
    rdm = new Random();
    population = new ArrayList<Agent>();
    

    // Creation d'un formuaire qui contient des boutons et la grille
    //
    Formulaire form = new Formulaire("TESTER",this,1200,800);

    // Creation des boutons et zones de saisies
    //
    form.setWidthButtonCour(300);
    form.addButton("DEP_ALEAT","Dep aleat");
    form.addButton("VERS_POINT","Vers le point designe");
    form.addButton("ENSEMBLE","Ensemble");
    form.addButton("FUIR","Fuir");
    form.addButton("CREER_NOIR","Creer agents noirs");
    form.addButton("CREER_ROUGE","Creer agents rouges");
    form.addText("NB_AGENTS","Nombre d'agents",true,"1");
    form.addButton("OBSTACLE","Obstacle");
    form.addButton("ERASE","Erase");
    
    // Creation de la grille
    form.setPosition(300,30);
    grille = form.addGrilleIHM(40,40,15,new TestActions());

    // Creation de l'espace mathematique de tore
    espace = new Tore(grille.getNbX(),grille.getNbY());

    // Affichage du formulaire
    form.afficher(50,50);
  }


  // La methode a implementer de l'interface FormualireInt pour le formulaire
  //
  public void     submit(Formulaire form,String nom)
  {
    // Pour changer le comportement de deplacement
    //
    pointCourant=null;
    if (nom.equals("DEP_ALEAT")) mode = 1;
    if (nom.equals("VERS_POINT")) mode = 2;
    if (nom.equals("ENSEMBLE")) mode = 3; 
    if (nom.equals("FUIR")) mode = 4; 
    if (nom.equals("OBSTACLE")) mode = 5; 

    // Creation d'un certain nombre d'agents noirs ou rouges
    //
    if (nom.equals("CREER_NOIR")) 
      {
        int nb = Integer.parseInt(form.getValeurChamp("NB_AGENTS"));
        for (int i=0;i<nb;i++)
          population.add(new Agent(numCourant++,1,new Point(rdm.nextInt(grille.getNbX()),
                                                 rdm.nextInt(grille.getNbY())),
                                   this));
        
      }
    if (nom.equals("CREER_ROUGE")) 
      {
        int nb = Integer.parseInt(form.getValeurChamp("NB_AGENTS"));
        for (int i=0;i<nb;i++)
          population.add(new Agent(numCourant++,9,new Point(rdm.nextInt(grille.getNbX()),
                                                 rdm.nextInt(grille.getNbY())),
                                   this));
        
      }

    // Efface les obstacles
    //
    if (nom.equals("ERASE")) 
      {
        for(int i=0;i<grille.getNbX();i++)
          for(int j=0;j<grille.getNbX();j++)
            grille.setMarque(0,i,j);
      }
  }

  // Action dans la grille
  //
  class TestActions implements ControlesCanvasIHM
  {
    public void pointerCaseGrille(int xCase,int yCase,CanvasIHM ihm)
    {
      // Si mode de deplacement vers points ou fuir
      //  on memorise le point designe
      //
      if ( (mode==2) || (mode==4) )
        {
          // Suppression du point courant
          if (grille.getMarque(xCase,yCase)==4)
            {
              ihm.setMarque(0,xCase,yCase);
              pointCourant=null;
            }
          // Creation du point courant
          else
            {
              pointCourant = new Point(xCase,yCase);
              ihm.setMarque(4,xCase,yCase);
            }
        }

      // Creation d'un obstacle
      //
      if (mode==5)
        {
          ihm.setMarque(4,xCase,yCase);
        }
    }

    // Non utilise
    public void pointerCanvas(Object target,int x,int y,CanvasIHM ihm)
    {
    }

  }
}
