package fr.cnam.connecteur;

import java.util.*;
import java.rmi.*;
import java.rmi.server.*;

public class ConnecteurClient extends UnicastRemoteObject implements IConnecteurClient
{
    IConnecteurServeur csv;
    ObservableClient obsva;

    public ConnecteurClient(int portRmi,String host,int port,String name) throws Exception
    {
        super(portRmi);
        csv = (IConnecteurServeur)Naming.lookup("rmi://"+host+":"+port+"/"+name);
        csv.connecter(RemoteObject.toStub(this));
        this.obsva = new ObservableClient();
    }

  public void addConsommateur(Observer consommateur)
  {
    obsva.addObserver(consommateur);
  }

    public void push(Object any)
    {
        System.out.println("push");
        obsva.setChanged();
        obsva.notifyObservers(any);
    }
    
    
}