package fr.cnam.connecteur;

import java.util.*;
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;

import fr.cnam.connecteur.*;

public class ConnecteurServeur extends UnicastRemoteObject implements IConnecteurServeur
{
    private ObservableServeur obsva;

    public ConnecteurServeur(int portRMI,String name) throws Exception
    {
        super(portRMI);
        try{
            LocateRegistry.createRegistry(9100);
        } catch(Exception ex){};
        
        Naming.rebind("rmi://localhost:9100/"+name,this);

        obsva = new ObservableServeur();
    }

    public void connecter(Remote stub) throws RemoteException
    {
        obsva.addObserver(new ObserverClient((IConnecteurClient)stub));
    }

    public void notifier(Object any)  throws RemoteException
    {
        try{
            System.out.println("notifier");
            obsva.setChanged();
            obsva.notifyObservers(any);
        }catch(Exception ex){System.out.println(ex);}
    }

}

    