package fr.cnam.ia;

import java.util.*;

public class AlphaBeta
{
  private AlphaBetaInt    _ia;              // Objet qui implmente AlphaBetaInt
  private int          _profondeur;      // Profondeur maximal 
  private int          _joueur;          // Numero du joueur qui joue automatiquement
  private int          _joueurAdverse;   // Numero du joueur adverse

  public AlphaBeta(AlphaBetaInt ia,    // L'objet qui implmente les mthodes de l'interface
                   int profondeur,  // profondeur maximal de recherche
                   int joueur,      // numro du joueur automatique
                   int joueurAdverse) // numro du joueur adverse
  {
    _ia            = ia;
    _profondeur    = profondeur;
    _joueur        = joueur;
    _joueurAdverse = joueurAdverse;
  }

  // mthode appel par le joueur automatique qui retourne le meilleur coup  jouer.
  //  EtatJeu est l'tat initial du jeu sur lequel il faut jouer un coup
  //
  public Object estimer(EtatJeu etatJeu)
  {
    ResultatAlphaBeta resultat = alphabeta(_joueur,etatJeu,0,-10000,+10000);
    return(resultat.coup);
  }

  // mthode rcurssive de recherche du meilleur coup
  // joueur est le joueur courant dans l'arbre de recherche
  // etatJeu est l'tat courant du jeu sur lequel le joueur doit jouer
  // profondeur est la profondeur courante
  // alpha est le seuil maximal d'allgage de l'arbre
  // beta  est le seuil minimal d'allgage de l'arbre
  //
  public ResultatAlphaBeta alphabeta(int joueur,EtatJeu etatJeu,int profondeur,int alpha,int beta)
  {
    ResultatAlphaBeta resultat ;

    // Determination des coups valides du joueur
    Vector v = _ia.coupsValides(joueur,etatJeu);
    if (v.size() == 0) // Si le joueur ne peut pas jouer
      {
        Vector v2 = _ia.coupsValides(getAdverse(joueur),etatJeu);
        if (v2.size() == 0) // Les 2 joueurs ne peuvent pas jouer
          resultat = _ia.evaluer(_joueur,joueur,getAdverse(joueur),null,etatJeu);
        else // Le joueur adverse joue
          resultat = alphabeta(getAdverse(joueur),etatJeu,profondeur+1,alpha,beta);
      }
    else
      {
        int minimum = +10000;
        int maximum = -10000;
        Object coup=null;
        for(int i=0;i<v.size();i++)
          {
            // On calcule la nouvelle position en fonction du coup jou
            EtatJeu etatJeuNew = _ia.majEtatJeu(joueur,
                                                etatJeu,
                                                v.elementAt(i));

            ResultatAlphaBeta result=_ia.evaluer(_joueur,joueur,getAdverse(joueur),v.elementAt(i),etatJeuNew);

            if ( (profondeur < _profondeur) && (result.prioritaire==0) )
              result=alphabeta(getAdverse(joueur),etatJeuNew,profondeur+1,alpha,beta);

            if (joueur == _joueur)
              {
                if (result.res > maximum) 
                  {
                    maximum = result.res;
                    coup = v.elementAt(i);
                  }
                if (maximum > alpha)  
                  {
                    alpha=maximum;
                    if (maximum>beta) 
                      {
                        resultat = new ResultatAlphaBeta(maximum,coup,0); // coupure beta
                        break;
                      }
                  }
              }
            else
              {
                if (result.res < minimum) 
                  {
                    minimum = result.res;
                    coup = v.elementAt(i);
                  }
                if (minimum < beta) 
                  {
                    beta=minimum;
                    if (minimum < alpha) 
                      {
                        resultat = new ResultatAlphaBeta(minimum,coup,0); // coupure alpha
                        break;
                      }
                  }
              }
          }

        // on retourne la valeur maximal ou minimal suivant le joueur courant
        if (joueur == _joueur) 
          resultat = new ResultatAlphaBeta(maximum,coup,0);
        else
          resultat = new ResultatAlphaBeta(minimum,coup,0);
      }
    
    return resultat;
  }

  // Valeur minimal entre deux entiers
  private int min(int a,int b)
  {
    if (a<b)return a; else return b;
  }

  // Retourne le numro du joueur adverse
  private int getAdverse(int joueur)
  {
    if (joueur == _joueur) return(_joueurAdverse);
    else return(_joueur);
  }

}
