package fr.cnam.othello.controleur;

import java.util.*;
import java.rmi.*;
import java.rmi.registry.*;

import fr.cnam.othello.model.*;
import fr.cnam.othello.vue.*;
import fr.cnam.prog.*;

// Proxy de communication vers le controleur du maitre.
// Ce proxy est utilise par l'esclave.
//
public class ControleurOthelloDistant implements ControleurOthello
{
  private ControleurOthelloODInt controleur; // interface distante du conroleur

  // Constructeur qui fait un lookup sur le controleur distant
  //
  public ControleurOthelloDistant()
  {
    String urmi=null;
    try
      {
        String host = Exercice06_Joueur.addresseHostJoueur1;
        urmi = "rmi://"+host+":9100/CONTROLEUR_OTHELLO";
        controleur = (ControleurOthelloODInt)Naming.lookup(urmi);
        System.out.println("Lookup sur controleur "+urmi);
      }
    catch(Exception ex){System.out.println("Erreur lookup sur "+urmi);}
  }

  // methodes du proxy
  // ------------------------------

  public boolean actionJouerOthello(int joueur,int x,int y)
  {
    try{
      return controleur.actionJouerOthello(joueur,x,y);
    }catch(Exception ex){return false;}
  }
  public void actionNotificationOthello()
  {
    try{
      controleur.actionNotificationOthello();
    }catch(Exception ex){};
  }
  // Ajouter un observer par l'esclave consiste a creer 
  //  un adaptateur de l'observeur distant et 
  //  faire le add observeur sur le contoleur distant qui va a son tour
  //  cree un proxy d'observer
  //
  public void addObserveur(Observer observeur)
  {
    try{
      AdaptObserverOthello adaptateur = new AdaptObserverOthello(9200,observeur);
      ObserverDistant obsdis = adaptateur.toStub();
      controleur.addObserveur(obsdis);
    }catch(Exception ex){
      try{
        AdaptObserverOthello adaptateur = new AdaptObserverOthello(9201,observeur);
        ObserverDistant obsdis = adaptateur.toStub();
        controleur.addObserveur(obsdis);
      }catch(Exception ex2){};
    };
  }

  public int getNumJoueurCourant()
  {
    try{
      return controleur.getNumJoueurCourant();
    }catch(Exception ex){return 0;}
  }

}
