package fr.cnam.othello.controleur;

import java.util.*;

import fr.cnam.othello.model.*;

// Class de definition du controleur du jeu d'othello
//  qui est un singleton
//
public class ControleurOthelloImpl implements ControleurOthello
{
  // L'attribut du singleton
  private static ControleurOthello controleurOthelloSingleton = null;

  // Attribut qui designe que ce singleton doit utiliser
  //  un controleur distant
  //
  private static boolean remote = false;
  
  // Le modele
  private ModelOthello modelOthello;
  
  // Constructeur
  //
  private ControleurOthelloImpl(ModelOthello model)
  {
    modelOthello = model;
  }

  // Pour positionner le mode remote
  //
  static public void remote()
  {
    remote=true;
  }

  // Creation du singleton
  //
  static public ControleurOthello getInstance()
  {
    if (controleurOthelloSingleton==null)
      {
        // Le controleur est local
        //
        if (!remote)
          {
            // Creation du controleur
            controleurOthelloSingleton = new ControleurOthelloImpl(new ModelOthello());

            // Creation de l'adaptateur pour utiliser le controleur de manire distant
            //  Celui du 2eme joueur ne se cree pas car meme port (9200)
            try
              {
                new ControleurOthelloODImpl(controleurOthelloSingleton);
              }
            catch(Exception ex){System.out.println("Erreur de creation du controleur OD");}
          }
        // Le controleur est distant
        //
        else
          controleurOthelloSingleton = new ControleurOthelloDistant();

      }

    return controleurOthelloSingleton;
  }


  // Action de jeu d'un joueur qui consiste a modifier le modele
  //
  synchronized public boolean actionJouerOthello(int joueur,int x,int y)
  {
    System.out.println("Controleur : actionJouerOthello");
    return modelOthello.jouerOthello(joueur,x,y);
  }

  // Action de demande au modele de notifier son etat
  //
  synchronized public void actionNotificationOthello()
  {
    System.out.println("actionNotificationOthello");
    if (modelOthello!=null)
      {
        modelOthello.notifierOthello();
      }
  }

  // Ajouter un observer a l'observable
  //
  synchronized public void addObserveur(Observer observeur)
  {
    modelOthello.getObservableOthello().addObserver(new ProxyObserverAsynchrone(observeur));
  }

  synchronized public int getNumJoueurCourant()
  {
    return modelOthello.getNumJoueurCourant();
  }

}
