package fr.cnam.othello.controleur;

import java.util.*;
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;

import fr.cnam.othello.model.*;
import fr.cnam.othello.controleur.*;
import fr.cnam.othello.vue.*;

// Adapteur RMI qui permet d'utiliser le controleur de maniere distant
//
public class ControleurOthelloODImpl extends UnicastRemoteObject implements ControleurOthelloODInt
{
  private ControleurOthello controleur; // Le controleur

  // Constructeur
  //
  public ControleurOthelloODImpl(ControleurOthello controleur) throws Exception
  {
    super(9200);
    this.controleur = controleur;

    // Creation de l'annuaire s'il n'existe pas dj
    try{LocateRegistry.createRegistry(9100);} catch(Exception ex){};

    String urmi = "rmi://localhost:9100/CONTROLEUR_OTHELLO";
    System.out.println("Service : "+urmi);
    Naming.rebind(urmi,this);
    System.out.println("Service connecteur enregistre : "+urmi);
  }

  // Les methodes adaptees :
  //-------------------------------

  public boolean actionJouerOthello(int joueur,int x,int y) throws RemoteException
  {
    try{
      return controleur.actionJouerOthello(joueur,x,y);
    }catch(Exception ex){return false;}
  }
  public void actionNotificationOthello() throws RemoteException
  {
    try{
      controleur.actionNotificationOthello();
    }catch(Exception ex){};
  }
  // On surcharge le traitement de la mthode addobserveur afin de creer
  //  un proxy d'Observer qui utilise l'oberveur distant passe en parametre
  //  qui est un stub 
  //
  public void addObserveur(ObserverDistant observeurDistant) throws RemoteException
  {
    try{
      System.out.println("Cration du proxy d'un observer distant");
      controleur.addObserveur(new ProxyObserverAsynchrone(new ProxyObserverOthello(observeurDistant)));
      System.out.println("Ajout du proxy comme observer de l'observable");
    }catch(Exception ex){System.out.println("Erreur addObserveur distant");};
  }

  public int getNumJoueurCourant() throws RemoteException
  {
    try{
      return controleur.getNumJoueurCourant();
    }catch(Exception ex){return 0;}
  }

}
