package fr.cnam.othello.model;

import java.util.*;
import java.awt.Point;

import fr.cnam.othello.vue.DataVueOthello;

// Classe de definition du modele du jeu d'othello
//
public class ModelOthello 
{
  public final static int NB_COLONNES = 8;
  public final static int NB_LIGNES   = 8;
  private ObservableOthello  observableOthello;
  private int[][] grilleModele;
  private int numJoueurCourant;

  // Constructeur
  //
  public ModelOthello()
  {
    this.observableOthello = new ObservableOthello();
    this.grilleModele = new int[NB_COLONNES][NB_LIGNES];
    this.numJoueurCourant = 1;

    //Init
    this.grilleModele[3][3]=1;
    this.grilleModele[3][4]=2;
    this.grilleModele[4][3]=1;
    this.grilleModele[4][4]=2;
  }

  
  // Traitement d'un coup d'un joueur
  //
  public boolean jouerOthello(int numJoueur,int x, int y)
  {
    if (numJoueurCourant!=numJoueur) 
      {
        return false;
      }

    // maj du jeu
    Vector pionsARetourner = calculerPrises(grilleModele,numJoueur,x,y);
    if (pionsARetourner.size()!=0)
      {
        for(int i=0;i<pionsARetourner.size();i++)
          {
            Point p = (Point)(pionsARetourner.elementAt(i));
            grilleModele[(int)p.x][(int)p.y] = numJoueur;
          }
        if (numJoueur==1) 
          {
            if (peutJouer(grilleModele,2))
              numJoueurCourant=2;
          }
        else 
          {
            if (peutJouer(grilleModele,1))
              numJoueurCourant=1;
          }
        // On notifie le nouvel etat de la grille du jeu
        //
        observableOthello.setChanged();
        observableOthello.notifyObservers(getData());
      }
    else
      {
        System.out.println("COUP INVALIDE");
        return false;
      }

    return true;
  }

  // getteurs
  //
  public ObservableOthello getObservableOthello()
  {
    return observableOthello;
  }
  public int getNumJoueurCourant()
  {
    return numJoueurCourant;
  }
  public DataVueOthello getData()
  {
    int[][] grille = new int[NB_COLONNES][NB_LIGNES];

    for(int i=0;i<NB_COLONNES;i++)
      for(int j=0;j<NB_LIGNES;j++)
        {
          grille[i][j]=grilleModele[i][j];
        }
    return  new DataVueOthello(grille);
  }
    
  // Notifier l'etat du modele (appele depuis le controleur)
  //
  public void notifierOthello()
  {
    System.out.println("notifierOthello");
    observableOthello.setChanged();
    observableOthello.notifyObservers(getData());
  }

  // Calcul les prises d'un coup d'un joueur en explorant les 8 directions du coup joue.
  // Retourne un Vector contenant les prises (Point)
  // Si le vecteur est vide alors cela veut dire que le coup n'est pas jouable
  //
  public static Vector calculerPrises(int[][] grilleModele,int joueur,int x,int y)
  {
    int tailleGrille = grilleModele[0].length;
    Point sens[]={new Point(-1,-1),
                  new Point(0,-1),
                  new Point(1,-1),
                  new Point(-1,0),
                  new Point(1,0),
                  new Point(-1,1),
                  new Point(0,1),
                  new Point(1,1)};
    Vector v = new Vector();

    // Si la case jouee n'est pas libre alors coup invalide
    if (grilleModele[x][y]!=0) return v;

    // On parcours les 8 sens possible a partir de la case joue
    //
    Point depart = new Point(x,y);
    for(int s=0;s<8;s++)
      {
        Point p = depart;
        boolean fini = false;
        Vector tmp = new Vector(); // Les cases dans un sens
        p = caseSuiv(p,sens[s]);
        while(!fini)
          {
            if( (pointDehors(p,tailleGrille)) || 
                (grilleModele[(int)p.x][(int)p.y]==0) )
              {
                fini=true;
                tmp= new Vector();
              }
            else
              {
                if(grilleModele[(int)p.x][(int)p.y]!=joueur)
                  {
                    tmp.addElement(p);
                    p=caseSuiv(p,sens[s]);
                  }
                else {fini=true;}
              }
          }
        // On ajoute les cases d'un sens
        for(int i=0;i<tmp.size();i++)
          {
            v.addElement(tmp.elementAt(i));
          }
      }

    // Si il existe des cases valides alors on ajoute 
    //  la case jouee
    if (v.size()!=0)
      v.addElement(depart);

    // On retourne les cases a retourner
    return(v);
  }

  // Teste si le point est en dehors de la grille
  //
  static public boolean pointDehors(Point p,int tailleGrille)
  {
    int px=(int)p.x;
    int py=(int)p.y;
    if ( (px<0)||
         (px>=tailleGrille)||
         (py<0)||
         (py>=tailleGrille))
      return(true);
    else
      return(false);
  }

  // Determine la case suivante en fonction d'un sens
  //
  static public Point caseSuiv(Point p,Point sens)
  {
    return( new Point(p.x+sens.x,
                      p.y+sens.y));
  }

  //Determine si un joueur peut jouer
  //
  static public boolean peutJouer(int[][] grilleModele,int joueur)
  {
    int nb=0;
    for(int i=0;i<NB_COLONNES;i++)
      for(int j=0;j<NB_LIGNES;j++)
        if (grilleModele[i][j]==0)
          {
            Vector v = calculerPrises(grilleModele,joueur,i,j);
            if (v.size()!=0) nb++;
          }
    if (nb==0)return false;
    else return true;
  }
}
