package fr.cnam.othello.model;

import java.util.*;

import fr.cnam.othello.model.ModelOthello;

// Proxy d'observer permettant de faire une notification asynchrone
// (dans un thread).
// Ceci est indispensable car dans la methode update le robot
//  appelle le controleur qui va modifier le modele et qui va 
//  notifier ... (cycle recurssif)
//  
//
public class ProxyObserverAsynchrone implements Observer
{
  private Observer observer;
  
  // Constructeur
  public ProxyObserverAsynchrone(Observer observer)
  {
    this.observer=observer;
  }
  
  // Methode de notification qui appelle la mthode update du stub
  //
  public void update(Observable o,Object arg)
  {
    try{
      // Appel de la methode update dans un thread
      new Thread(new Runnable(){public void run(){try{observer.update(o,arg);}catch(Exception ex){}}}).start();

    }catch(Exception ex){System.out.println(">>ProxyObserverAsynchrone>update: Erreur ");
      ex.printStackTrace();};
  }
}