package fr.cnam.othello.vue;

import java.util.*;
import java.rmi.*;
import java.rmi.registry.*;
import java.rmi.server.*;

// Classe qui adapte l'observeur local afin qu'il puisse
//  etre utilis a travers une interface distante 
//
public class AdaptObserverOthello extends UnicastRemoteObject implements ObserverDistant
{
  Observer observeurLocal;
    
  // Constructeur
  public AdaptObserverOthello(int port,Observer observeurLocal) throws RemoteException
  {
    super(port);
    System.out.println("Creation de l'adaptateur observer sur port "+port);
    this.observeurLocal=observeurLocal;
  }

  // Methode de notification 
  //
  public void update(Observable o,Object arg)  throws RemoteException
  {
    System.out.println(">>AdaptObserverOthello>update");
    DataVueOthello data = (DataVueOthello)arg;
    observeurLocal.update(o,data);
  }

  // Le stub
  //
  public ObserverDistant toStub() 
  {
    try{
      ObserverDistant stub = (ObserverDistant)(UnicastRemoteObject.toStub(this));
      System.out.println("Recuperation du stub");
      if (stub==null)
        System.out.println("Le stub est null");
      return stub;
    }catch(Exception ex){System.out.println("Erreur sur toStub ");return null;}
  }
}